#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import print_function
from __future__ import absolute_import
from builtins import object
from qgis.core import QgsApplication
from qgis.PyQt.QtCore import QFileInfo, QObject
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.PyQt.QtGui import QIcon
import os
from .config import config as cfg
# Initialize Qt resources from file resources.py
from mapstream import resources_rc

class MapStream(object):
    """QGIS interface implementation of the plugin.
    This class acts as glue between QGIS and the different steps/scripts"""
    
    dlg = None

    def __init__(self, iface):
        """Class constructor: on instantiation, the plugin instance will be
        assigned a copy of the QGIS interface (iface) object which allows this
        plugin to access and manipulate the running QGIS instance.
        """
        self.iface = iface
       # self.dlg = None

    def initGui(self):
        """Gui initialisation procedure (for QGIS plugin api).
        This method is called by QGIS and is used to set up all graphical user
        interface elements that appear in QGIS by default (before the user
        performs any explicit action with the plugin)."""
        PLUGIN_NAME = cfg.plugin_name()  # this string is used in the button's tooltip
        PLUGINS_FOLDER = cfg.qgis_plugins_path()
        ICONS_DICT = cfg.icons()
        QGIS_DIR = QFileInfo(QgsApplication.qgisUserDatabaseFilePath()).path().replace('/', os.sep)
        arr_map_dir = (QGIS_DIR,) + tuple(PLUGINS_FOLDER.split('/')) + (PLUGIN_NAME,)
        MAP_DIR = os.path.join(os.sep, *arr_map_dir)
        arr_icon_path = (MAP_DIR, ICONS_DICT["folder_name"], ICONS_DICT["icon_file"]) 
        ICON_REL_PATH = os.path.join(os.sep, *arr_icon_path)
        self.main = QAction(QIcon(ICON_REL_PATH),  PLUGIN_NAME, self.iface.mainWindow())
        self.main.triggered.connect(self.run_dialog)  # connection of signal to slot
        self.iface.addToolBarIcon(self.main)
        self.menu = self.iface.pluginMenu().addMenu(QIcon(ICON_REL_PATH), PLUGIN_NAME)
        self.menu.addAction(self.main)
        self.main.setStatusTip(PLUGIN_NAME)  # string shown in the status area at the bottom of the QGIS main window

    def unload(self):
        """Gui breakdown procedure (for QGIS plugin api). Method removes
        any graphical user interface elements that were created by the plugin"""
        # Remove the plugin menu items and icons
        self.menu.removeAction(self.main)
        self.iface.removeToolBarIcon(self.main)
        self.iface.unregisterMainWindowAction(self.main)
        # remove menu item
        self.iface.pluginMenu().removeAction(self.menu.menuAction())

    def run_dialog(self):
        try:
            from .main_dialog import MainDialog
            if self.dlg is None:
                self.dlg = MainDialog(self.iface)
                self.dlg.setModal(False)
                self.dlg.show()
                #alla fine dell'esecuzione, reinizializza dlg a None per impedire aperture multiple dell'interfaccia
                result = self.dlg.exec_()
                self.dlg = None
        except Exception as ex:
            print(ex)
            QMessageBox.warning(self.iface.mainWindow(), "Warning", "UI loading error.")
            return False