#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import print_function
from __future__ import absolute_import
from builtins import str
from qgis.core import QgsVectorFileWriter, QgsVectorLayer, QgsField, QgsGeometry, QgsFeature, QgsPointXY, QgsRendererCategory, QgsRendererRange, QgsGraduatedSymbolRenderer, QgsCategorizedSymbolRenderer, QgsFillSymbol, QgsSymbol, QgsApplication, QgsProject
from qgis.PyQt.QtCore import Qt, QObject, QTimer, QThread, QVariant, QFileInfo, pyqtSignal
# from qgis.PyQt import QtWidgets

from qgis.PyQt.QtGui import QCursor, QColor
from qgis.PyQt.QtWidgets import QMessageBox, QFileDialog, QDialog, QApplication
from qgis.analysis import *
from qgis.gui import QgsMapTool
import sys
import os.path
# import winsound
from collections import defaultdict
sys.path.append(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + "/python/plugins/mapstream")
# from . import serial
import serial
import time
from .ui_main import Ui_Main
# from .connection_utils import SerialThread, scan_services



import csv
# from dbfread import DBF
import pandas as pd
from dbfread import DBF

#CREO LE CLASSI PER GESTIRE LE FORM DI INSERIMENTO PUNTI E POLIGONI
from mapstream import ClasseStazione
from mapstream import ClassePoligono
from mapstream import ClasseMisura

FIX_BRUTALE = True

# IS_BLE_VERSION = False
IS_BLE_VERSION = True

import asyncio
import bleak

from ble_connection.ble_measure_handler import BleReaderThread
from ble_connection.ble_connection import BluetoothScannerThread

# from .ble_thread import BluetoothScanTask


class FormPoligoni(QDialog, ClassePoligono.Ui_Dialog_Poligoni):

    def __init__(self, parent=None):
        global idPoligonoCorrente
        global tmpArea
        global tmpPerimetro
        global ZMaxPoligono
        global ZMinPoligono
        pendenza = abs(ZMaxPoligono - ZMinPoligono)
        super(FormPoligoni, self).__init__(parent)
        self.setupUi(self)
        self.HMU_NUM.setText(str(idPoligonoCorrente))
        #self.AREA.setText(str(tmpArea))
        #self.PERIMETER.setText(str(tmpPerimetro))
        self._HMU_TYPE.insertSeparator(8)
        self._HMU_TYPE.insertSeparator(14)
        self.AREA.setText('{0:.3f}'.format(tmpArea))
        self.PERIMETER.setText('{0:.3f}'.format(tmpPerimetro))
        self.PENDENZA.setText('{0:.3f}'.format(pendenza))
        self.buttonBox.accepted.connect(self.accept)
        self.buttonBox.rejected.connect(self.reject)

    def accept(self):
        global DialogPoligono
        global idPoligonoCorrente


        def ControllaStato(value):
            if value == 0:
                return "False"
            elif value == 1:
                return "True"
            else:
                return "True"
        DialogPoligono = []
        DialogPoligono.append(self.HMU_NUM.text())
        if self._HMU_TYPE.currentText() == 'Backwater':
            DialogPoligono.append('BACKWATER')
        elif self._HMU_TYPE.currentText() == 'Cascade':
            DialogPoligono.append('CASCADE')
        elif self._HMU_TYPE.currentText() == 'Dune':
            DialogPoligono.append('DUNE')
        elif self._HMU_TYPE.currentText() == 'Glide':
            DialogPoligono.append('GLIDE')
        elif self._HMU_TYPE.currentText() == 'Isolated Pond':
            DialogPoligono.append('ISOL_POND')
        elif self._HMU_TYPE.currentText() == 'Plunge pool':
            DialogPoligono.append('PLUNGE_POOL')                    
        elif self._HMU_TYPE.currentText() == 'Pool':
            DialogPoligono.append('POOL')
        elif self._HMU_TYPE.currentText() == 'Pothole':
            DialogPoligono.append('POTHOLE')
        elif self._HMU_TYPE.currentText() == 'Rapid':
            DialogPoligono.append('RAPID')
        elif self._HMU_TYPE.currentText() == 'Riffle':
            DialogPoligono.append('RIFFLE')
        elif self._HMU_TYPE.currentText() == 'Rock glide':
            DialogPoligono.append('ROCK_GLIDE')
        elif self._HMU_TYPE.currentText() == 'Step':
            DialogPoligono.append('STEP')
        elif self._HMU_TYPE.currentText() == 'Step':
            DialogPoligono.append('STEP')
        elif self._HMU_TYPE.currentText() == 'Waterfall':
            DialogPoligono.append('WATERFALL')
        elif self._HMU_TYPE.currentText() == 'Aquatic vegetation':
            DialogPoligono.append('AQUAT_VEG')
        elif self._HMU_TYPE.currentText() == 'Secondary channel':
            DialogPoligono.append('SEC_CHAN')
        elif self._HMU_TYPE.currentText() == 'Floodplane lake':
            DialogPoligono.append('FLOOD_LAKE')
        elif self._HMU_TYPE.currentText() == 'Wetland':
            DialogPoligono.append('WETLAND')
        elif self._HMU_TYPE.currentText() == 'Artificial element':
            DialogPoligono.append('ARTIF_ELEM')
        elif self._HMU_TYPE.currentText() == 'Hydraulic unit':
            DialogPoligono.append('HYDR_UNIT')

        #DialogPoligono.append(self._HMU_TYPE.currentText())
        if ControllaStato(self._RIPRAP.checkState()) == 'True':
            self._BOULDER.setChecked(True)
            QMessageBox.question(
                self, "Message",
                "By checking the cover type 'RIPRAP', also the cover type 'BOULDER' "
                "cover will be noted in the HMU attribute table.", QMessageBox.Ok)

        DialogPoligono.append(ControllaStato(self._CONNECTIV.checkState()))
        DialogPoligono.append(ControllaStato(self._BOULDER.checkState()))
        DialogPoligono.append(ControllaStato(self._CANOP_SHAD.checkState()))
        DialogPoligono.append(ControllaStato(self._OVERHA_VEG.checkState()))
        DialogPoligono.append(ControllaStato(self._ROOTS.checkState()))
        DialogPoligono.append(ControllaStato(self._SUBMER_VEG.checkState()))
        DialogPoligono.append(ControllaStato(self._EMERG_VEG.checkState()))
        DialogPoligono.append(ControllaStato(self._UNDERC_BAN.checkState()))
        DialogPoligono.append(ControllaStato(self._WOODY_DEBR.checkState()))
        DialogPoligono.append(ControllaStato(self._RIPRAP.checkState()))
        DialogPoligono.append(ControllaStato(self._SHALL_MARG.checkState()))
        DialogPoligono.append(self.COMMENT.toPlainText())
        idPoligonoCorrente = int(self.HMU_NUM.text()) + 1
        self.done(0)

    def reject(self):
        self.done(1)

class FormStazioni(QDialog, ClasseStazione.Ui_Dialog_Stazioni):
    
    def __init__(self, parent=None):
        global idNumeroStazioni
        global tmpSD
        global tmpAZ
        global tmpINC
        super(FormStazioni, self).__init__(parent)
        self.setupUi(self)
        self.NSTAZ.setText(str(idNumeroStazioni))
        self.SD.setText(str(tmpSD))
        self.AZ.setText(str(tmpAZ))
        self.INC.setText(str(tmpINC))
        self.buttonBox.accepted.connect(self.accept)
        self.buttonBox.rejected.connect(self.reject)

    def accept(self):
        global DialogStazione
        DialogStazione = []
        DialogStazione.append(self.NSTAZ.text())
        DialogStazione.append(self.SD.text())
        DialogStazione.append(self.AZ.text())
        DialogStazione.append(self.INC.text())
        DialogStazione.append(self.COMMENT.toPlainText())
        DialogStazione.append("0")
        self.done(0)

    def reject(self):
        self.done(1)

class FormMisure(QDialog, ClasseMisura.Ui_Dialog_Misure):
    
    def __init__(self, parent=None):
        # global idPunto
        # global tmpSD
        # global tmpAZ
        # global tmpINC

        # global PoligonoCorrente
        # global TipoPoligonoCorrente
        
        super(FormMisure, self).__init__(parent)
        self.setupUi(self)
        
        self.PNTNUM.setText(str(idPunto))
        self.SD.setText(str(tmpSD))
        self.AZ.setText(str(tmpAZ))
        self.INC.setText(str(tmpINC))
        self.HMU_NUM.setText(str(PoligonoCorrente))
        self.HMU_TYPE.setText(str(TipoPoligonoCorrente))
        
        self.buttonBox.accepted.connect(self.accept)
        self.buttonBox.rejected.connect(self.reject)


    def accept(self):
        global DialogMisura
        global idPunto
        global PoligonoCorrente
        global TipoPoligonoCorrente                

        def ControllaStato(value):
            if value == 0:
                return "False"
            else:
                return "True"                
        
        DialogMisura = []
        DialogMisura.append(self.PNTNUM.text())
        DialogMisura.append(self.VELOCITY.text())
        DialogMisura.append(self.DEPTH.text())

        PoligonoCorrente = int(self.HMU_NUM.text())
        TipoPoligonoCorrente = self.HMU_TYPE.text()

        if self._SUBSTRATE.currentText() == 'Gigalithal (Rocks)':
            DialogMisura.append('GIGALITHAL')
        elif self._SUBSTRATE.currentText() == 'Megalithal (M40)':
            DialogMisura.append('MEGALITHAL')
        elif self._SUBSTRATE.currentText() == 'Macrolithal (20-40)':
            DialogMisura.append('MACROLITHAL')
        elif self._SUBSTRATE.currentText() == 'Mesolithal (6-20)':
            DialogMisura.append('MESOLITHAL')
        elif self._SUBSTRATE.currentText() == 'Microlithal (2-6)':
            DialogMisura.append('MICROLITHAL')
        elif self._SUBSTRATE.currentText() == 'Akal (Gravel)':
            DialogMisura.append('AKAL')
        elif self._SUBSTRATE.currentText() == 'Psammal (Sand)':
            DialogMisura.append('PSAMMAL')
        elif self._SUBSTRATE.currentText() == 'Pelal (Clay)':
            DialogMisura.append('PELAL')
        elif self._SUBSTRATE.currentText() == 'Detritus (Organic)':
            DialogMisura.append('DETRITUS')
        elif self._SUBSTRATE.currentText() == 'Xylal (Dead wood)':
            DialogMisura.append('XYLAL')
        elif self._SUBSTRATE.currentText() == 'Sapropel (Sludge)':
            DialogMisura.append('SAPROPEL')
        elif self._SUBSTRATE.currentText() == 'Phytal (Moss, fungi)':
            DialogMisura.append('PHYTAL')



        #DialogMisura.append(self.SUBSTRATE.CurrentText())
        DialogMisura.append(ControllaStato(self._ESTIMATED.checkState()))
        DialogMisura.append(self.SD.text())
        DialogMisura.append(self.AZ.text())
        DialogMisura.append(self.INC.text())
        DialogMisura.append(self.COMMENT.toPlainText())

        idPunto = int(self.PNTNUM.text()) + 1

        self.done(0)

    def reject(self):
        self.done(1)

class PointTool(QgsMapTool):   
    pinpoint_signal = pyqtSignal(str, name = 'pinpoint_signal')

    def __init__(self, canvas):
        QgsMapTool.__init__(self, canvas)
        self.canvas = canvas    

    def canvasPressEvent(self, event):
        pass

    def canvasMoveEvent(self, event):
        x = event.pos().x()
        y = event.pos().y()
        point = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)

    def canvasReleaseEvent(self, event):
        #Get the click
        x = event.pos().x()
        y = event.pos().y()
        point = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
        self.pinpoint_signal.emit(str(point[0]) + "_" + str(point[1]))

    def activate(self):
        pass

    def deactivate(self):
        pass

    def isZoomTool(self):
        return False

    def isTransient(self):
        return False

    def isEditTool(self):
        return True





# class ThreadEndCommunicator(QObject):
#     message_signal = pyqtSignal(str)


#Main Dialog class creation (includes some methods like __init__ and runalg)
class MainDialog(QDialog, Ui_Main):

    # initialize the button and sto thread
    def initialize_ble_devices_list(self):
        # print("2 - Called initialize ble devices list")
        self.ElencoPorteCom.clear()
        self.ble_devices_list = [self.scan_text]
        self.ble_devices_list.insert(0, "")
        self.ElencoPorteCom.addItems(self.ble_devices_list)
        # print("3 - etichetta settata a 'Choose Option'")
        self.ble_connection_label(6, "") # Choose option
        # QApplication.processEvents()


    # def stop_and_initialize_thread(self):
    #     #-->print("---> if exist stop and initialize thread")
    #     if self.ble_reader_thread:
    #         if self.ble_reader_thread.isRunning():
    #             print("The BLE thread is active.")
    #         # stop ble_thread
    #         self.ble_reader_thread.stop()
    #         # Attende la terminazione del thread BLE
    #         self.ble_reader_thread.wait()
    #         # Accetta l'evento di chiusura
    #         self.Logs('Thread correctly closed')
    #         #-->print('Thread correctly closed')
    #
    #         self.ble_reader_thread = None
    #         #-->print("Thread initialized as None")
    #     else:
    #         print("No active thread")
    #     #-->print("<--- END stop and initialize thread")

    #
    #
    # def close_external_thread_connection(self):
    #     #-->print("Sending close signal...")
    #     self.ble_connection_end_communicator.message_signal.emit("close__")
    #


    #__init__ method, initializes the UI buttons, line edits, ... for the first start
    def __init__(self, iface):

        self.dir_path = None

        #initialize dialog and setup
        QDialog.__init__(self, iface.mainWindow())
        #QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)
        self.timer = QTimer()
        # self.timer.timeout.connect(self.refresh_COM_connection)
        # self.timer.start(30000)
        self.plugin_dir = QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + "/python/plugins/mapstream"
        self.__receiver = None
        self.__thread = None
        self.ser = None
        self.toolBox.setCurrentIndex(0)

        # self.combo_complete = ['COM%s' % (i + 1) for i in range(256)]
        # services, services_lookups = scan_services()
        self.scan_text = "Scan devices"
        self.RESET_NAME = "Reset Devices List"

        if not IS_BLE_VERSION:
            self.services_lookups = None
            self.ElencoPorteCom.clear()
            self.combo_complete = [self.scan_text]
            self.combo_complete.insert(0, "")
            self.ElencoPorteCom.addItems(self.combo_complete)
            self.connection_label(4, "")
        else:
            ########################################### BLE VERSION ####################################################

            # inizializzazione
            self.label_3.setText("BLE Device")
            self.ble_device_name = None

            self.initialize_ble_devices_list()
            self.ble_connection_label(4, "") # "not yet initialized" only first time

            # gestione thread per connessione
            self.ble_scanner_thread = None
            self.ble_devices_list = []
            ###############
            # gestione thread per misure
            self.ble_reader_thread = None

            ############################################################################################################



        self.lblTestoX.hide()
        self.lblTestoY.hide()
        self.lblTestoZ.hide()
        self.txtValoreX.hide()
        self.txtValoreX_2.hide()
        self.txtValoreX_3.hide()
        self.cmdPloti.hide()
        self.cmdSalvaLavoro.setEnabled(False)
        self.cmdChiudiPoligonoCorrente.setEnabled(False)
        self.DeletePointButton.setEnabled(False)
        self.UI_obj_cnns()
        self.Logs("Welcome to MapStream")

        # change layer symbology
        self.DEPTH_SYMB.stateChanged.connect(self.ConditionalSymb_DEPTH)
        self.VEL_SYMB.stateChanged.connect(self.ConditionalSymb_VEL)
        self.SUBST_SYMB.stateChanged.connect(self.ConditionalSymb_SUBST)

        #Inizializzazione variabili
        global DialogStazione
        DialogStazione = None
        global DialogMisura
        DialogMisura = None
        global DialogPoligono
        DialogPoligono = None
        global tmpSD
        tmpSD = None
        global tmpAZ
        tmpAZ = None
        global tmpINC
        tmpINC = None
        # area e poligono
        global tmpArea
        tmpArea = 0
        global tmpPerimetro
        tmpPerimetro = 0
        global PendenzaPoligono
        PendenzaPoligono = 0
        global HabitatPoligono
        HabitatPoligono = 0
        global ZMaxPoligono
        ZMaxPoligono = 0
        global ZMinPoligono
        ZMinPoligono = 0
        global layer_1
        global v2
        global v3
        global v4
        v3 = None           # layer pulti posizione telemetro - stazioni
        v2 = None           # layer poligoni - sequenze morfologiche
        layer_1 = None           # layer punti rilevati con il telemetro
        v4 = None  
        global  punti        # layer punti rilevati con il telemetro e riferiti ai vertici dei poligoni
        punti = None
        global poligono
        poligono = None
        global cPoligono
        cPoligono = None
        global punti_posizione_telemetro
        punti_posizione_telemetro = None
        global PoligonoCorrente
        PoligonoCorrente = -1       # Contiene l'indice del poligono che è stato selezionato e nel quale si devono inserire i punti di rilevamento
        global TipoPoligonoCorrente
        TipoPoligonoCorrente = ""   # Contiene il tipo del poligono che è stato selezionato e nel quale si devono inserire i punti di rilevamento
        global RSSelezionata
        RSSelezionata = ""          # Contiene la RS Selezionata a livello di codice
        global pathFileHMU
        pathFileHMU = ""
        global pathFileVERTEX
        pathFileVERTEX = ""
        global pathFileMEAS
        pathFileMEAS = ""
        global pathFileSTATION
        pathFileSTATION = ""
        global pathFileProgettoQGIS
        pathFileProgettoQGIS = ""
        global idPunto
        idPunto = 0
        global idVertice
        idVertice = 0
        global NumeroVerticiRelativiAlPoligono
        NumeroVerticiRelativiAlPoligono = 0
        global idUltimoVertice
        idUltimoVertice = None
        global idNumeroStazioni
        idNumeroStazioni = 0
        global inEsecuzione
        inEsecuzione = False
        global boolDummyStation
        boolDummyStation = True        
        global idLayerPoligoni
        idLayerPoligoni = "NESSUN NOME"
        global idPoligonoCorrente
        idPoligonoCorrente = 0
        global Xorigine
        Xorigine = 5
        global Yorigine
        Yorigine = 5
        self.PinPointButton.setEnabled(False)


    def UI_obj_cnns(self):

        # open existing project
        self.cmdApriLavoroEsistente.clicked.connect(self.ApriFileEsistenti)
        # self.cmdApriLavoroEsistente.clicked.connect(self.save_txt)

        # select CRS
        self.cmdSelectRS.clicked.connect(self.SelezionaRS)
        # self.cmdSelectRS.clicked.connect(self.save_txt)

        # save new project
        self.cmdSalvaLavoro.clicked.connect(self.PreparaFilesPerSalvareIDati)

        # enable or disable button respect checkbox clicked
        self.chkMisura.clicked.connect(self.enable_buttons)
        self.chkStazione.clicked.connect(self.enable_buttons)
        self.chkVertice.clicked.connect(self.enable_buttons)

        # enable or disable other checkbox respect checkbox clicked
        self.chkStazione.stateChanged.connect(self.SelezionaStazione)
        self.chkVertice.stateChanged.connect(self.SelezionaVertice)
        self.chkMisura.stateChanged.connect(self.SelezionaMisura)

        # pinpoint drawing
        self.PinPointButton.clicked.connect(self.TogglePinPointing)

        # delete last point
        self.DeletePointButton.clicked.connect(self.RimuoviUltimoPuntoDaLayer)

        # change station
        self.cmdCreaNuovoPoligono.clicked.connect(self.CambiaCoordinateOrigine)

        # go to last station
        self.cmdGotoLastStation.clicked.connect(self.SelezionaUltimaStazione)

        # close current hmu
        self.cmdChiudiPoligonoCorrente.clicked.connect(self.DisegnaPoligono)

        # for bt connection
        if IS_BLE_VERSION:
            self.ElencoPorteCom.activated.connect(lambda: self.BLE_connection(self.ElencoPorteCom.currentText()))
        # else:
        #     self.ElencoPorteCom.activated.connect(lambda: self.COM_connection(self.ElencoPorteCom.currentText()))


        # for hide or show manual meas
        self.manualmeascheckBox.stateChanged.connect(self.hide_show_manual_meas)
        
        self.cmdPloti.clicked.connect(self.DisegnaPunto)





    # log message
    def Logs(self, log_cnt):
        time_string = "{}:{}:{} - ".format(str(time.localtime()[3]), str(time.localtime()[4]), str(time.localtime()[5]))
        self.ElencoErrori.append(time_string + str(log_cnt))
        pass

    # open existing project
    def ApriFileEsistenti(self):
        # print("A" * 1000)
        import os
        global pathFileHMU
        global pathFileVERTEX
        global pathFileMEAS
        global pathFileSTATION
        global RSSelezionata
        global idPunto
        global idVertice
        global idNumeroStazioni
        global idPoligonoCorrente
        global Xorigine
        global Yorigine
        global layer_1
        global v2
        global v3
        global v4
        file, __ = QFileDialog.getOpenFileName(None, None, None, "MapStream Project (*.mhs)")
        # print("??" * 1000)
        # print(f"file: {file}")
        # print(f"__ : {__}")

        self.dir_path = os.path.dirname(file)
        # print(f"self.dir_path: {self.dir_path}")
        # print("??" * 1000)

        if file == "":
            self.toolBox.setCurrentIndex(1)
            return
        reader = open(file, 'r')
        for line in reader:
            line = line.strip()
            if line != "":
                if line[0:3] == "SR:":
                    RSSelezionata = line.replace("SR:", "")

                if line[0:4] != "RIVE" and line[0:4] != "DATA":
                    if "HMU" in line.upper():
                        pathFileHMU = line
                    elif "MEAS" in line.upper():
                        pathFileMEAS = line
                    elif "STATION" in line.upper():
                        pathFileSTATION = line
                    elif "VERTEX" in line.upper():
                        pathFileVERTEX = line
        self.CreaNuovoLayer("OPEN")
        self.DisegnaPoligono("OPEN")
        Xorigine = 5.0
        Yorigine = 5.0
        # INSERISCO LE MISURE
        vlayer = QgsVectorLayer(os.path.abspath(pathFileMEAS), "PUNTI", "ogr")
        idPunto = 1
        if not vlayer.isValid():
            self.Logs("Data source is not valid")
        else:
            lista = vlayer.getFeatures()
            layer_1.startEditing()
            for feature in lista:
                idPunto = idPunto + 1
                prTmp = layer_1.dataProvider()
                prTmp.addFeatures([feature])
            layer_1.commitChanges()
            layer_1.updateExtents()
        # INSERISCO LE STAZIONI
        vlayer = QgsVectorLayer(os.path.abspath(pathFileSTATION), "PUNTI", "ogr")
        idNumeroStazioni = 1
        if not vlayer.isValid():
            self.Logs("Data source is not valid")
        else:
            lista = vlayer.getFeatures()
            v3.startEditing()
            for feature in lista:
                idNumeroStazioni = idNumeroStazioni + 1
                prTmp = v3.dataProvider()
                prTmp.addFeatures([feature])
                if feature['CURRENT'] == '1':
                    # point = feature.geometry().asPoint()
                    Xorigine = feature.geometry().asPoint().x()
                    Yorigine = feature.geometry().asPoint().y()
                    self.Logs("Station coordinates moved to %s, %s" % (str(Xorigine), str(Yorigine),))
            v3.commitChanges()
            v3.updateExtents()
        # INSERISCO I VERTICI
        vlayer = QgsVectorLayer(os.path.abspath(pathFileVERTEX), "PUNTI", "ogr")
        idVertice = 1
        if not vlayer.isValid():
            self.Logs("Data source is not valid")
        else:
            lista = vlayer.getFeatures()
            # idVertice = idVertice + 1        #questo va nel ciclo for
            v4.startEditing()
            for feature in lista:
                idVertice = idVertice + 1
                prTmp = v4.dataProvider()
                prTmp.addFeatures([feature])
            v4.commitChanges()
            v4.updateExtents()
        # INSERISCO I POLIGONI
        idPoligonoCorrente = 1
        vlayer = QgsVectorLayer(os.path.abspath(pathFileHMU), "POLIGONI", "ogr")
        if not vlayer.isValid():
            self.Logs("Data source is not valid")
        else:
            lista = vlayer.getFeatures()
            v2.startEditing()
            for feature in lista:
                idPoligonoCorrente = idPoligonoCorrente + 1
                prTmp = v2.dataProvider()
                prTmp.addFeatures([feature])
            v2.commitChanges()
            v2.updateExtents()
        self.toolBox.setCurrentIndex(2)

    # select CRS
    def SelezionaRS(self):
        # print("B" * 1000)
        # from qgis.gui import QgsGenericProjectionSelector
        from qgis.gui import QgsProjectionSelectionWidget
        from qgis.core import QgsCoordinateReferenceSystem
        global RSSelezionata
        v = QgsProjectionSelectionWidget()
        # exec the iface
        v.selectCrs()
        RSSelezionata = v.crs().authid()
        self.cmdSalvaLavoro.setEnabled(True)
        x = QgsCoordinateReferenceSystem(v.crs())
        self.cmdSelectRS.setText(str(x.description()))
        self.Logs("Reference System adopted: {}".format(str(x.description())))
        self.Logs("Authority id: {}".format(RSSelezionata))

    # save new project
    def PreparaFilesPerSalvareIDati(self):
        # print("C" * 1000)
        from os.path import expanduser
        import shutil
        global pathFileHMU
        global pathFileVERTEX
        global pathFileMEAS
        global pathFileSTATION
        global pathFileProgettoQGIS
        global RSSelezionata
        # Apre il dialog box per ricercare la posizione dove creare la cartella e salvare i files
        directory = QFileDialog.getExistingDirectory(None, "Open a folder", expanduser("~"), QFileDialog.ShowDirsOnly)
        # La directory che contiene il fascicolo viene chiamata con CORSO_ACQUA_YYYYMMDD
        # in questo modo tutti i fascicoli per lo stesso corso d'acqua sono vicini
        # Poi all'interno della directory ci sono i file SHAPE con nome
        #    FIUME-HMU-DDMMYYYY
        #    FIUME-VERTEX-%DDMMYYYY
        #    FIUME-MEAS-%DDMMYYYY
        #    FIUME-STATION-%DDMMYYYY

        directory = '%s\\%s_%s%s%s' % (directory,
                                        self.txtCorsoAcqua.text().replace(" ", "_"),
                                        str(self.DateSelector.date().year()).zfill(2),
                                        str(self.DateSelector.date().month()).zfill(2),
                                        str(self.DateSelector.date().day()).zfill(2),)


        self.dir_path = directory
        if not os.path.exists(directory):
            os.makedirs(directory)
        pathFileProgettoQGIS = '%s\\%s_%s%s%s.qgs' % (directory,
                                        self.txtCorsoAcqua.text().replace(" ", "_"),
                                        str(self.DateSelector.date().year()).zfill(2),
                                        str(self.DateSelector.date().month()).zfill(2),
                                        str(self.DateSelector.date().day()).zfill(2),)
        # COPIA RecuperoDati.pyc
        shutil.copy(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + "/python/plugins/mapstream/RecuperoDati.py", directory)
        # Creo un file di configurazione che puo' essere utilizzato di seguito. Vengono elencati
        #   il nome del corso d'acqua
        #   la data di rilevamento
        #   la tipologia di portata stimata a vista
        #   i nomi dei file SHP che compongono il progetto
        NomeFile = '%s\\%s' % (directory, 'Config.mhs', )
        file = open(NomeFile, "w")
        file.write('RIVER    : %s\n' % self.txtCorsoAcqua.text())
        file.write('DATA     : %s/%s/%s\n' % (
            str(self.DateSelector.date().day()).zfill(2),
            str(self.DateSelector.date().month()).zfill(2),
            str(self.DateSelector.date().year()).zfill(4),))
        file.write('SR:%s\n' % RSSelezionata)
        pathFileHMU = r'%s\%s-HMU-%s%s%s.shp' % (
            directory,
            self.txtCorsoAcqua.text().replace(" ", "_"),
            str(self.DateSelector.date().day()).zfill(2),
            str(self.DateSelector.date().month()).zfill(2),
            str(self.DateSelector.date().year()).zfill(4),)
        file.write('%s\n' % pathFileHMU)
        pathFileVERTEX = r'%s\%s-VERTEX-%s%s%s.shp' % (
            directory,
            self.txtCorsoAcqua.text().replace(" ", "_"),
            str(self.DateSelector.date().day()).zfill(2),
            str(self.DateSelector.date().month()).zfill(2),
            str(self.DateSelector.date().year()).zfill(4),)
        file.write('%s\n' % pathFileVERTEX)
        pathFileMEAS = r'%s\%s-MEAS-%s%s%s.shp' % (
            directory,
            self.txtCorsoAcqua.text().replace(" ", "_"),
            str(self.DateSelector.date().day()).zfill(2),
            str(self.DateSelector.date().month()).zfill(2),
            str(self.DateSelector.date().year()).zfill(4),)
        file.write('%s\n' % pathFileMEAS)
        pathFileSTATION = r'%s\%s-STATION-%s%s%s.shp' % (
            directory,
            self.txtCorsoAcqua.text().replace(" ", "_"),
            str(self.DateSelector.date().day()).zfill(2),
            str(self.DateSelector.date().month()).zfill(2),
            str(self.DateSelector.date().year()).zfill(4),)
        file.write('%s\n' % pathFileSTATION)
        file.close()
        self.CreaNuovoLayer("INIT")
        self.toolBox.setCurrentIndex(2)

    # enable or disable button respect checkbox clicked
    def enable_buttons(self):
        # print("D" * 1000)
        global NumeroVerticiRelativiAlPoligono
        global v3

        # PINPOINT BUTTON
        if self.chkMisura.isChecked():
            self.PinPointButton.setEnabled(True)
        elif self.chkStazione.isChecked():
            self.PinPointButton.setEnabled(True)
        else:
            self.PinPointButton.setEnabled(False)
            self.ClosePinPointing()

        # DELETE LAST POINT BUTTON
        if self.chkMisura.isChecked():
            punti = list(layer_1.getFeatures())
            if len(punti) > 0:
                self.DeletePointButton.setEnabled(True)
            else:
                self.DeletePointButton.setEnabled(False)
        elif self.chkStazione.isChecked():
            punti = list(v3.getFeatures())
            if len(punti) > 0:
                self.DeletePointButton.setEnabled(True)
            else:
                self.DeletePointButton.setEnabled(False)
        else:
            if NumeroVerticiRelativiAlPoligono > 0:
                self.DeletePointButton.setEnabled(True)
            else:
                self.DeletePointButton.setEnabled(False)

    # enable or disable other checkbox respect checkbox clicked
    def SelezionaStazione(self):
        if self.chkStazione.isChecked():
            self.chkVertice.setChecked(False)
            self.chkMisura.setChecked(False)

    def SelezionaVertice(self):
        if self.chkVertice.isChecked():
            self.chkStazione.setChecked(False)
            self.chkMisura.setChecked(False)

    def SelezionaMisura(self):
        if self.chkMisura.isChecked():
            self.chkStazione.setChecked(False)
            self.chkVertice.setChecked(False)

    # pinpoint drawing
    def TogglePinPointing(self):
        # print("E"*1000)
        #initializing my custom PointTool
        self.tool = PointTool(self.iface.mapCanvas())
        self.tool.pinpoint_signal.connect(self.get_point_signal)
        #activating PointTool
        self.iface.mapCanvas().setMapTool(self.tool)
        cursor = QCursor()
        cursor.setShape(Qt.CrossCursor)
        self.iface.mapCanvas().setCursor(cursor)

    # signal for drawing point on layer
    def get_point_signal(self, str):
        global tmpSD
        global tmpAZ
        global tmpINC
        tmpSD, tmpINC, tmpAZ = None, None, None
        self.DisegnaPuntoSuLayer(SDdistanza=None, AZimuth=None, INClinazione=None, pinpointstring=str)

    # close pint point drawing
    def ClosePinPointing(self):
        # print("E2 "*1000)
        # self.Logs("Entrata in ClosePinPointing")
        self.iface.actionPan().trigger()

    # delete last point
    def RimuoviUltimoPuntoDaLayer(self):
        # print("F" * 1000)
        global idVertice
        global idUltimoVertice
        global NumeroVerticiRelativiAlPoligono
        global poligono
        global layer_1
        global v4
        global v3
        global idPunto

        if self.chkStazione.isChecked():
            _label = "STATION"
            punti = list(v3.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
            _id_last = punti[-1].id()
            v3.select(_id_last)

        elif self.chkVertice.isChecked():
            _label = "VERTEX"
            v4.select(idUltimoVertice)

        elif self.chkMisura.isChecked():
            _label = "MEAS"
            punti = list(layer_1.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
            _id_last = punti[-1].id()
            layer_1.select(_id_last)

        else:
            raise Exception("Something wrong with checkboxes")
        _msg = 'Do you want to delete last {} point?'.format(_label)
        reply = QMessageBox.question(self, 'Message', _msg, QMessageBox.Yes, QMessageBox.No)

        if reply == QMessageBox.Yes:
            if self.chkVertice.isChecked():
                idVertice = idVertice - 1
                NumeroVerticiRelativiAlPoligono = NumeroVerticiRelativiAlPoligono - 1
                if NumeroVerticiRelativiAlPoligono < 1:
                    self.DeletePointButton.setEnabled(False)
                if NumeroVerticiRelativiAlPoligono < 4:
                    self.cmdChiudiPoligonoCorrente.setEnabled(False)
                poligono.pop()  # last element removed
                self.Logs("Removing VERTEX")
                v4.startEditing()  # QgsVectorLayer
                v4.deleteFeature(idUltimoVertice)
                v4.commitChanges()
            if self.chkStazione.isChecked():
                punti = list(v3.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
                _id_last = punti[-1].id()
                self.Logs("Removing STATION")
                v3.startEditing()
                v3.deleteFeature(_id_last)
                v3.commitChanges()
                if len(punti) == 1:
                    self.DeletePointButton.setEnabled(False)
            if self.chkMisura.isChecked():
                punti = list(layer_1.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
                _id_last = punti[-1].id()
                self.Logs("Removing MEAS")
                layer_1.startEditing()
                layer_1.deleteFeature(_id_last)
                layer_1.commitChanges()
                idPunto = idPunto - 1
                if len(punti) == 1:
                    self.DeletePointButton.setEnabled(False)
        elif reply == QMessageBox.No:
            if self.chkStazione.isChecked():
                _label = "STATION"
                punti = list(v3.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
                _id_last = punti[-1].id()
                v3.deselect(_id_last)

            elif self.chkVertice.isChecked():
                _label = "VERTEX"
                v4.deselect(idUltimoVertice)

            elif self.chkMisura.isChecked():
                _label = "MEAS"
                punti = list(
                    layer_1.getFeatures())  # WARN: Ci fidiamo che le feature sono restituite in ordine cronologico
                _id_last = punti[-1].id()
                layer_1.deselect(_id_last)

    # change station
    def CambiaCoordinateOrigine(self):
        # print("G" * 1000)
        global Xorigine
        global Yorigine
        global v3
        global punti_posizione_telemetro
        if pathFileHMU == "":
            return
        feature = v3.selectedFeatures()
        if len(feature) > 0:
            prXXX = v3.dataProvider()
            punti = prXXX.getFeatures()
            attrName = 'CURRENT'
            for p in punti:
                p[attrName] = '0'
                prXXX.changeAttributeValues({p.id() : {prXXX.fieldNameMap()[attrName] : '0'}})
            prXXX.changeAttributeValues({feature[0].id() : {prXXX.fieldNameMap()[attrName] : '1'}})
            point = feature[0].geometry().asPoint()
            Xorigine = point.x()
            Yorigine = point.y()
            punti_posizione_telemetro.append([point, 0, 0, 0, 0])
            self.Logs("Station coordinates moved to %s, %s" % (str(Xorigine), str(Yorigine),))
            v3.triggerRepaint()
            v3.removeSelection()
            self.iface.mapCanvas().refresh()
            self.SalvataggioDatiInShapeFile(v3, "STATION")

    # go to last station
    def SelezionaUltimaStazione(self):
        # print("H" * 1000)
        global Xorigine
        global Yorigine
        global v3
        global punti_posizione_telemetro
        if pathFileHMU == "":
            return
        # recupero l'elenco completo delle stazioni presenti sul layer
        prXXX = v3.dataProvider()
        punti = prXXX.getFeatures()
        attrName = 'CURRENT'
        for p in punti:
            feature = p
            p[attrName] = '0'
            prXXX.changeAttributeValues({p.id(): {prXXX.fieldNameMap()[attrName]: '0'}})
        prXXX.changeAttributeValues({feature.id(): {prXXX.fieldNameMap()[attrName]: '1'}})
        point = feature.geometry().asPoint()
        Xorigine = point.x()
        Yorigine = point.y()
        punti_posizione_telemetro.append([point, 0, 0, 0, 0])
        self.Logs("Station coordinates moved to %s, %s" % (str(Xorigine), str(Yorigine),))
        self.SalvataggioDatiInShapeFile(v3, "STATION")
        v3.triggerRepaint()
        self.iface.mapCanvas().refresh()

    # close current hmu (draw polygon)
    def DisegnaPoligono(self, tipo):
        # print("I"*1000)
        global idLayerPoligoni
        global poligono
        global cPoligono
        global idPoligonoCorrente
        global punti
        global DialogPoligono
        global v2
        global NumeroVerticiRelativiAlPoligono
        global RSSelezionata
        global tmpArea
        global tmpPerimetro
        global ZMaxPoligono
        global ZMinPoligono
        global idPunto
        pendenza = ZMaxPoligono - ZMinPoligono
        tmpArea = 0
        tmpPerimetro = 0

        # define a lookup: value -> (color, label)
        suit_color = {"POTHOLE": ('#000000', "POTHOLE"),
                      "CASCADE": ('#9900CC', "CASCADE"),
                      "RAPID": ('#0000ff', "RAPID"),
                      "RIFFLE": ('#66FFFF', "RIFFLE"),
                      "STEP": ('#ff0000', "STEP"),
                      "POOL": ('#ffff00', "POOL"),
                      "GLIDE": ('#00ff00', "GLIDE"),
                      "DUNE": ('#8220A5', "DUNE"),
                      "AQUAT_VEG": ('#274e13', "AQUAT_VEG"),
                      "SEC_CHAN": ('#99FF99', "SEC_CHAN"),
                      "FLOOD_LAKE": ('#003366', "FLOOD_LAKE"),
                      "WETLAND": ('#FF9966', "WETLAND"),
                      "ARTIF_ELEM": ('#FFFFFF', "ARTIF_ELEM"),
                      "WATERFALL": ('#999966', "WATERFALL"),
                      "PLUNGE_POOL": ('#FF9900', "PLUNGE_POOL"),
                      "BACKWATER": ('#990033', "BACKWATER"),
                      "ISOL_POND": ('#37aba6', "ISOL_POND"),
                      "ROCK_GLIDE": ('#FF33CC', "ROCK_GLIDE"),
                      "HYDR_UNIT": ('#32C8C8', "HYDR_UNIT")
                      }
        # create the renderer and assign it to a layer
        expression = "HMU_TYPE"  # field name
        if tipo != "OPEN":
            _Ptmp = QgsGeometry.fromPolygonXY([poligono])
            tmpArea = _Ptmp.area()
            tmpPerimetro = _Ptmp.length()
            form12 = FormPoligoni()
            form12.show()
            result = form12.exec_()
            if result == 0:
                idPoligonoCorrente = int(DialogPoligono[0])
            else:
                return
        if idLayerPoligoni == "NESSUN NOME":
            stringa_crs_multip = 'multipolygon?crs={}'.format(RSSelezionata)
            v2 = QgsVectorLayer(stringa_crs_multip, "HMU", "memory")
            pr = v2.dataProvider()
            v2.startEditing()
            pr.addAttributes([QgsField("HMU_NUM", QVariant.Int),
                              QgsField("HMU_TYPE", QVariant.String, "", 20),
                              QgsField("CONNECTIV", QVariant.String, "", 5),
                              QgsField("BOULDER", QVariant.String, "", 5),
                              QgsField("CANOP_SHAD", QVariant.String, "", 5),
                              QgsField("OVERHA_VEG", QVariant.String, "", 5),
                              QgsField("ROOTS", QVariant.String, "", 5),
                              QgsField("SUBMER_VEG", QVariant.String, "", 5),
                              QgsField("EMERG_VEG", QVariant.String, "", 5),
                              QgsField("UNDERC_BAN", QVariant.String, "", 5),
                              QgsField("WOODY_DEBR", QVariant.String, "", 5),
                              QgsField("RIPRAP", QVariant.String, "", 5),
                              QgsField("SHALL_MARG", QVariant.String, "", 5),
                              QgsField("COMMENT", QVariant.String, "", 500)])
            props = {'color': '255, 0, 0', 'style': 'solid'}
            if tipo != "OPEN":
                poly = QgsFeature()
                poly.setGeometry(_Ptmp)
                poly.setAttributes([idPoligonoCorrente,
                                    DialogPoligono[1],
                                    round(ZMaxPoligono, 3),
                                    round(ZMinPoligono, 3),
                                    DialogPoligono[2],
                                    DialogPoligono[3],
                                    DialogPoligono[4],
                                    DialogPoligono[5],
                                    DialogPoligono[6],
                                    DialogPoligono[7],
                                    DialogPoligono[8],
                                    DialogPoligono[9],
                                    DialogPoligono[10],
                                    DialogPoligono[11],
                                    DialogPoligono[12],
                                    DialogPoligono[13]])
                pr.addFeatures([poly])
            # create a category for each item
            categories = []
            for hmu_type, (color, label) in list(suit_color.items()):
                symbol = QgsSymbol.defaultSymbol(v2.geometryType())
                symbol.setColor(QColor(color))
                category = QgsRendererCategory(hmu_type, symbol, label)
                categories.append(category)
            idLayerPoligoni = v2.name()
            s = QgsFillSymbol.createSimple(props)
            # v2.setRendererV2( QgsSingleSymbolRenderer( s ) )
            v2.setRenderer(QgsCategorizedSymbolRenderer(expression, categories))
            v2.setMinimumScale(1.0)
            v2.setMaximumScale(1000.0)
            # v2.setEditorLayout(QgsVectorLayer.UiFileLayout)
            # v2.setEditForm(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + 'python/plugins/mapstream/poligoni.ui')
            # v2.setEditFormInit("RecuperoDati.Poligoni")
            v2.selectionChanged.connect(self.SelezionaPoligono)
            v2.layerModified.connect(self.SalvaModificheManualiPunti)
            v2.commitChanges()
            v2.updateExtents()
            QgsProject.instance().addMapLayer(v2)
            if tipo != "OPEN":
                cPoligono.append(poly)
        else:
            if tipo != "OPEN":
                v2 = self.getVectorLayerByName(idLayerPoligoni)
                v2.startEditing()
                pr = v2.dataProvider()
                v2.startEditing()
                poly = QgsFeature()
                poly.setGeometry(_Ptmp)
                poly.setAttributes([idPoligonoCorrente,
                                    DialogPoligono[1],
                                    round(ZMaxPoligono, 3),
                                    round(ZMinPoligono, 3),
                                    DialogPoligono[2],
                                    DialogPoligono[3],
                                    DialogPoligono[4],
                                    DialogPoligono[5],
                                    DialogPoligono[6],
                                    DialogPoligono[7],
                                    DialogPoligono[8],
                                    DialogPoligono[9],
                                    DialogPoligono[10],
                                    DialogPoligono[11],
                                    DialogPoligono[12],
                                    DialogPoligono[13]])
                pr.addFeatures([poly])
                props = {'color': '255, 0, 0', 'style': 'solid'}
                s = QgsFillSymbol.createSimple(props)
                v2.setMinimumScale(1.0)
                v2.setMaximumScale(1000.0)
                v2.commitChanges()
                v2.updateExtents()
                # create a category for each item
                categories = []
                for hmu_type, (color, label) in list(suit_color.items()):
                    symbol = QgsSymbol.defaultSymbol(v2.geometryType())
                    symbol.setColor(QColor(color))
                    category = QgsRendererCategory(hmu_type, symbol, label)
                    categories.append(category)
                v2.setRenderer(QgsCategorizedSymbolRenderer(expression, categories))
                cPoligono.append(poly)
        # v2.updateExtents()
        # v2.commitChanges()
        if tipo != "OPEN":
            self.SalvataggioDatiInShapeFile(v2, "HMU")
        poligono = []
        idPoligonoCorrente = idPoligonoCorrente + 1
        NumeroVerticiRelativiAlPoligono = 0
        idPunto = 1
        # rendo nuovamente bloccati i pulsanti di chiusura del poligono e rimozione ultimo punto
        self.cmdChiudiPoligonoCorrente.setEnabled(False)
        if tipo != "OPEN":
            self.DeletePointButton.setEnabled(False)

        # Zmax and Zmin Correction 29-08-2019
        vfs = v4.getFeatures()
        hfs = v2.getFeatures()

        zhmu = defaultdict(list)
        for vf in vfs:
            z = vf['Z']
            hhmu = vf['HMU_NUM']
            zhmu[hhmu].append(z)

        for k in list(zhmu.keys()):
            zmax = max(zhmu[k])
            zmin = min(zhmu[k])
            zhmu[k] = [zmax, zmin]

        v2.startEditing()
        for hf in hfs:
            for k in list(zhmu.keys()):
                if hf['HMU_NUM'] == k:
                    v2.changeAttributeValue(hf.id(), v2.fields().lookupField("Z_MAX"), zhmu[k][0])
                    v2.changeAttributeValue(hf.id(), v2.fields().lookupField("Z_MIN"), zhmu[k][1])
        v2.commitChanges()

    # change layer symbology
    def ConditionalSymb_DEPTH(self):
        # print("L1"*500)
        if self.DEPTH_SYMB.checkState() == 'True':
            self.DEPTH_SYMB.setChecked(True)
        if self.DEPTH_SYMB.isChecked():
            self.VEL_SYMB.setChecked(False)
            self.SUBST_SYMB.setChecked(False)
            symbologyClasses = (
                ('< 15 cm', 0, 0.15, '#0c457d'),
                ('15 - 30 cm', 0.15, 0.30, '#0392cf'),
                ('30 - 45 cm', 0.30, 0.45, '#00b159'),
                ('45 - 60 cm', 0.45, 0.60, '#88d8b0'),
                ('60 - 75 cm', 0.60, 0.75, '#dcedc1'),
                ('75 - 90 cm', 0.75, 0.90, '#ffdc73'),
                ('90 - 105 cm', 0.90, 1.05, '#ffc425'),
                ('105 - 120 cm', 1.05, 1.20, '#f37735'),
                ('> 120 cm', 1.20, 1000, '#990000'),
            )
            categoriasymb = []

            for label, lower, upper, color in symbologyClasses:
                symbol = QgsSymbol.defaultSymbol(layer_1.geometryType())
                # symbol = layer_1.renderer().symbol().setSize(3)
                symbol.setColor(QColor(color))
                rng = QgsRendererRange(lower, upper, symbol, label)
                categoriasymb.append(rng)

            expression = 'DEPTH'
            renderer = QgsGraduatedSymbolRenderer(expression, categoriasymb)
            layer_1.setRenderer(renderer)
            layer_1.triggerRepaint()

    def ConditionalSymb_VEL(self):
        # print("L2" * 500)
        if self.VEL_SYMB.checkState() == 'True':
            self.VEL_SYMB.setChecked(True)
        if self.VEL_SYMB.isChecked():
            self.DEPTH_SYMB.setChecked(False)
            self.SUBST_SYMB.setChecked(False)
            symbologyClasses = (
                ('< 15 cm/s', 0, 0.15, '#0c457d'),
                ('15 - 30 cm/s', 0.15, 0.30, '#0392cf'),
                ('30 - 45 cm/s', 0.30, 0.45, '#00b159'),
                ('45 - 60 cm/s', 0.45, 0.60, '#88d8b0'),
                ('60 - 75 cm/s', 0.60, 0.75, '#dcedc1'),
                ('75 - 90 cm/s', 0.75, 0.90, '#ffdc73'),
                ('90 - 105 cm/s', 0.90, 1.05, '#ffc425'),
                ('105 - 120 cm/s', 1.05, 1.20, '#f37735'),
                ('> 120 cm/s', 1.20, 10.00, '#990000'),
            )
            categoriasymb = []

            for label, lower, upper, color in symbologyClasses:
                symbol = QgsSymbol.defaultSymbol(layer_1.geometryType())
                # symbol = layer_1.renderer().symbol().setSize(3)
                symbol.setColor(QColor(color))
                rng = QgsRendererRange(lower, upper, symbol, label)
                categoriasymb.append(rng)

            expression = 'VELOCITY'
            renderer = QgsGraduatedSymbolRenderer(expression, categoriasymb)
            layer_1.setRenderer(renderer)
            layer_1.triggerRepaint()
            layer_1.triggerRepaint()

    def ConditionalSymb_SUBST(self):
        # print("L3" * 500)
        if self.SUBST_SYMB.checkState() == 'True':
            self.SUBST_SYMB.setChecked(True)
        if self.SUBST_SYMB.isChecked():
            self.DEPTH_SYMB.setChecked(False)
            self.VEL_SYMB.setChecked(False)
            substrates = {
                'GIGALITHAL': ('#7d7c7a', 'Gigalithal (Rocks)'),
                'MEGALITHAL': ('#990000', 'Megalithal (> 40 cm)'),
                'MACROLITHAL': ('#e37602', 'Macrolithal (20 - 40 cm)'),
                'MESOLITHAL': ('#fce808', 'Mesolithal (6 - 20 cm)'),
                'MICROLITHAL': ('#00b159', 'Microlithal (2 - 6 cm)'),
                'AKAL': ('#0392cf', 'Akal (Gravel)'),
                'PSAMMAL': ('#0c457d', 'Psammal (Sand)'),
                'PELAL': ('#87037c', 'Pelal (Clay)'),
                'DETRITUS': ('#c7d6a1', 'Detritus (Organic)'),
                'XYLAL': ('#634517', 'Xylal (Dead wood)'),
                'SAPROPEL': ('#3d3430', 'Sapropel (Sludge)'),
                'PHYTAL': ('#5c7051', 'Phytal (Moss, Fungi'),
            }

            categories = []
            for subst_name, (color, label) in substrates.items():
                symbol = QgsSymbol.defaultSymbol(layer_1.geometryType())
                symbol.setColor(QColor(color))
                category = QgsRendererCategory(subst_name, symbol, label)
                categories.append(category)

            # create the renderer and assign it to a layer
            expression = 'SUBSTRATE'  # field name
            renderer = QgsCategorizedSymbolRenderer(expression, categories)
            layer_1.setRenderer(renderer)
            layer_1.triggerRepaint()

########################################################################################################################
########################################################################################################################
######################################## CODE FOR BLE DEVICE ###########################################################
########################################################################################################################
########################################################################################################################
    def ble_connection_label(self, cn_type, port):
        cnn_status = {
            0: ("green", "Connected"), #
            1: ("red", "Unconnected"), #
            2: ("blue", "Connecting"),
            3: ("black", "Select Device"),
            4: ("black", "Not yet initialized"),
            5: ("blue", "Scanning devices"),
            6: ("black", "Choose option"),
        }
        if cn_type <= 2:
            self.CnnStatusLabel.setText("{} ({})".format(cnn_status[cn_type][1], self.ble_device_name))
        else:
            self.CnnStatusLabel.setText(cnn_status[cn_type][1])
        self.CnnStatusLabel.setStyleSheet('color: {}'.format(cnn_status[cn_type][0]))

    def BLE_connection(self, port_text):
        """
        When ElencoPorteCom combobox is activated, this function is called.
        Label text is port_text parameter.
        The value of port text activate different functions.
        """
        #-->print("\n--> call BLE connection\n")
        #-->print(f"port_text value = {port_text}")

        # rindondanre, basterebbe una volta qui, per maggiore chiarezza ripeto
        # self.stop_and_initialize_thread()

        if port_text == "" or port_text == " " or not port_text:
            #-->print("port_text is empty, close thread and initialize")
            self.stopConnectionThread()  ######################## <-----------------------------

            self.initialize_ble_devices_list()
            # self.stop_and_initialize_thread()


        elif port_text == self.scan_text: # Scanning devices
            #-->print("-----> Scanning devices")
            self.start_scan()


        elif port_text == self.RESET_NAME:
            self.stopConnectionThread() ######################## <-----------------------------
            # #-->print(f"-----> Devices list reset")
            self.initialize_ble_devices_list()
            # self.stop_and_initialize_thread()
            # #-->print("<---- END reset")


        else:
            if not self.CnnStatusLabel.text().startswith("Connected (") :
                #-->print(f"-----> Connection with Selected device {port_text}")
                self.ble_device_name = port_text
                self.ble_device_address = [d[port_text] for d in self.ble_devices_list if list(d.keys())[0] == port_text][0]

                QMessageBox.information(self, "Connection with BLE device",
                                        f"Connection with\nName: {self.ble_device_name}\nAddress: {self.ble_device_address}")



                # creo e avvio il thread
                # self.ble_reader_thread = BleReaderThread(self.device_address, self.characteristic_uuid)
                self.ble_reader_thread = BleReaderThread(DEVICE_ADRESS=self.ble_device_address,
                                                         DEVICE_NAME=self.ble_device_name)

                #-->print("Connection with selected device...")
                self.ble_connection_label(2, port_text)
                QApplication.processEvents()



                # quando ricevo una misura mi colego a onDataReceived
                # self.ble_reader_thread.measurement_received.connect(self.onDataReceived)
                self.ble_reader_thread.measurement_received.connect(self.Decifra_Disegna_BLE)

                # QUANDO SENTO IL CONNECTION TIMEOUT MI FERMO (thread già chiuso di la)
                self.ble_reader_thread.connection_timeout.connect(self.handle_timeout)

                self.ble_reader_thread.connection_status.connect(self.onConnectionStatus)

                self.ble_reader_thread.error_signal.connect(self.onError)

                self.ble_reader_thread.start()
            else:
                _msg = "Device is already connected!"
                #-->print(_msg)
                self.Logs(_msg)


        #-->print("\n<-- END BLE connection\n")

    def Decifra_Disegna_BLE(self, bt_string):
        # print("::::::::::::::::::::::::::::::::::::::::::")
        # print("::::::::::::::::::::::::::::::::::::::::::")
        # print("bt_string = ", bt_string)
        global tmpSD
        global tmpAZ
        global tmpINC
        global idLayerPoligoni
        global idPoligonoCorrente
        global idNumeroStazioni
        global PoligonoCorrente


        if (layer_1 != None) & (v2 != None) & (v3 != None) & (v4 != None):
            if self.chkMisura.isChecked() and idLayerPoligoni == "NESSUN NOME":
                QMessageBox.information(self, 'MEASURE', 'No polygon selected', QMessageBox.Ok)
                PoligonoCorrente = idPoligonoCorrente

            # AZ | SD | INC
            idx_SD = 1
            idx_AZ = 0
            idx_INC = 2

            tmpSD = 0.0
            tmpAZ = 0.0
            tmpINC = 0.0

            if bt_string.split('@')[idx_SD] == "":
                self.txtValoreX.setText("0")
            if bt_string.split('@')[idx_AZ] == "":
                self.txtValoreX_2.setText("0")
            if bt_string.split('@')[idx_INC] == "":
                self.txtValoreX_3.setText("0")

            tmpSD = float(bt_string.split('@')[idx_SD])
            tmpAZ = float(bt_string.split('@')[idx_AZ])
            tmpINC = float(bt_string.split('@')[idx_INC])

            self.Logs(f"(SD, AZ, INC) = ({tmpSD}, {tmpAZ}, {tmpINC})")
            # self.Logs(f"tmpSD = {tmpSD}")
            # self.Logs(f"tmpAZ = {tmpAZ}")
            # self.Logs(f"tmpINC = {tmpINC}")

            # print(f"tmpSD = {tmpSD}")
            # print(f"tmpAZ = {tmpAZ}")
            # print(f"tmpINC = {tmpINC}")
            # print("::::::::::::::::::::::::::::::::::::::::::")
            # print("::::::::::::::::::::::::::::::::::::::::::")


            self.DisegnaPuntoSuLayer(float(bt_string.split('@')[idx_SD]), float(bt_string.split('@')[idx_AZ]),
                                     float(bt_string.split('@')[idx_INC]))
            self.Logs(f"Point drawn correctly.")
            time.sleep(0.1)
        else:
            self.Logs("Bluetooth signal received, but no layers detected.")

    def handle_timeout(self, timeout_msg):
        # comunico solo uscita, sono gia usicot nel thread stesso
        # print("Gestione timeout --> setto etichetta a non connessa")
        self.ble_connection_label(1, self.ble_device_name) # Unconnected
        QMessageBox.critical(self, "Connection Timeout", timeout_msg)
        # self.stop_and_initialize_thread()
        self.Logs(timeout_msg)

    def onConnectionStatus(self, connected):
        # status = "Connesso" if connected else "Disconnesso"
        # se ricevo il segnale di disconnesso lo disconnetto
        if connected:
            #-->print(f"Segnale Connesso: {connected}")
            self.ble_connection_label(0, self.ble_device_name)  # connected
            self.Logs("Connected with device: {}".format(self.ble_device_name))
        # elif not connected:
        #     print(f"Segnale NON ___ Connesso: {connected}")
            # self.ble_connection_label(1, self.ble_device_name) # UNCONNECTED

    def stopConnectionThread(self):
        #-->print("___________________________________________________________________")
        #-->print(f"{self.ble_reader_thread = }")
        # print(f"1 - Called self.stopConnectionThread(), {self.ble_reader_thread = }")
        if self.ble_reader_thread and self.ble_reader_thread.isRunning():
            self.ble_reader_thread.abort()
            self.ble_reader_thread.wait()
            self.ble_reader_thread.deleteLater()
            self.ble_reader_thread = None
        #-->print("___________________________________________________________________")

    def stopReading(self):

        self.stopConnectionThread()
        # self.ble_connection_label(1, self.ble_device_name) # UNCONNECTED

    def onError(self, error_msg):

        # self.ble_connection_label(6, self.ble_device_name)  # Choose Option
        # resetto elenco
        self.initialize_ble_devices_list()

        QMessageBox.critical(
            self,
            "Errore",
            error_msg
        )
        #-->print("chiamata onError chiusura tutto")
        self.stopReading()

    # gestione connessione
    def start_scan(self):

        # durante scansione disabilita pulsante e cambia testo
        self.ElencoPorteCom.setEnabled(False)
        self.ble_connection_label(5, self.ElencoPorteCom.currentText())  # Scanning devices
        #-->print("Scanning in new thread...")


        # crea e avvia il thread

        """Avvia lo scan Bluetooth"""
        # Crea e avvia il thread
        self.ble_scanner_thread = BluetoothScannerThread()

        # mi metto in ascolto dei segnali, in base a quello che arriva attivo una roba o un'altra
        # self.scanner_thread.deviceFound.connect(self.onDeviceFound)
        self.ble_scanner_thread.devices_found.connect(self.update_found_ble_list)
        self.ble_scanner_thread.error_signal.connect(self.on_error)

        self.ble_scanner_thread.start()

    def update_found_ble_list(self, devices):
        """Aggiorna la combobox con i dispositivi trovati"""
        # self.sfCombo.clear()
        #-->print("-----------> received devices list from ble thread:")
        # for device in devices:
            #-->print(f"\t\t---> {device}")

        self.ble_devices_list = devices


        # if at least one device
        if self.ble_devices_list:
            self.ble_devices_list += [{self.RESET_NAME: ""}]
            # self.ble_connection_label(3, self.ElencoPorteCom.currentText()) # select device

            self.ElencoPorteCom.clear()
            self.ElencoPorteCom.addItems([key for d in self.ble_devices_list for key in d.keys()])
            self.ble_connection_label(3, self.ElencoPorteCom.currentText()) # select device
        else:
            self.Logs("No devices were found during the scan.")
            self.ble_connection_label(6, self.ElencoPorteCom.currentText())  # Choose oprion

        self.ElencoPorteCom.setEnabled(True)

    def on_error(self, error_msg):
        QMessageBox.critical(
            self,
            "Errore",
            error_msg
        )
        self.ElencoPorteCom.setEnabled(True)
        #-->print("se serve cambio testo....")

########################################################################################################################
########################################################################################################################
########################################################################################################################
########################################################################################################################
########################################################################################################################

    def SalvaModificheManualiPuntiV1(self):
        global layer_1
        self.Logs("Saving data in MEAS shapefile")
        self.SalvataggioDatiInShapeFile(layer_1, "MEAS")

    def SalvaModificheManualiPuntiV2(self):
        global v2
        self.Logs("Saving data in HMU shapefile")
        self.SalvataggioDatiInShapeFile(v2, "HMU")

    def SalvaModificheManualiPuntiV3(self):
        global v3
        self.Logs("Saving data in STATION shapefile")
        self.SalvataggioDatiInShapeFile(v3, "STATION")

    def SalvaModificheManualiPuntiV4(self):
        global v4
        self.Logs("Saving data in VERTEX shapefile")
        self.SalvataggioDatiInShapeFile(v4, "VERTEX")

    def DisegnaPuntoSuLayer(self, SDdistanza, AZimuth, INClinazione, pinpointstring=None):
        # ATTIVA LA MODALITA MODIFICA
        import math
        global idPunto
        global idVertice
        global idUltimoVertice
        global NumeroVerticiRelativiAlPoligono
        global idNumeroStazioni
        global layer_1
        global v4
        global v3
        global punti
        global poligono
        global idPoligonoCorrente
        global Xorigine
        global Yorigine
        global DialogStazione
        global DialogMisura
        global PoligonoCorrente
        global TipoPoligonoCorrente
        global ZMaxPoligono
        global ZMinPoligono
        if pathFileHMU == "":
            return
        # CONTROLLO LA NATURA DEL PUNTO E DECIDO SU QUALE LAYER DISEGNARLA
        pr = None
        #STATION
        if self.chkStazione.isChecked():
            self.Logs("Drawing STATION")
            v3.startEditing()
            # recupero l'elenco completo delle stazioni presenti sul layer
            punti = v3.getFeatures()
            # progressivo locale al poligono
            maxpunto = 0
            for p in punti:
                maxpunto = maxpunto + 1    # mi limito a contare quante stazioni ci sono
            idNumeroStazioni = maxpunto + 1 
            # APRO IL POPUP RELATIVO AI DATI DELLA STAZIONE
            form12 = FormStazioni()
            form12.show()
            result = form12.exec_()
            if result == 0:
                try:
                    idNumeroStazioni = int(DialogStazione[0])
                    SDdistanza = float(DialogStazione[1])
                    AZimuth = float(DialogStazione[2])
                    INClinazione = float(DialogStazione[3])
                except ValueError:
                    pass   
            else:
                idNumeroStazioni = maxpunto
                return
        #VERTEX        
        elif self.chkVertice.isChecked():
            self.Logs("Drawing VERTEX")
            v4.startEditing()

        #MEAS
        else:
            self.Logs("Drawing MEAS")
            layer_1.startEditing()
            # APRO IL POPUP RELATIVO AI DATI DELLA MISURAZIONE
            form12 = FormMisure()
            form12.show()
            result = form12.exec_()

            punti = layer_1.getFeatures()
            if result == 0:
                try:
                    idPunto = int(DialogMisura[0])
                    SDdistanza = float(DialogMisura[5])
                    AZimuth = float(DialogMisura[6])
                    INClinazione = float(DialogMisura[7])
                except ValueError:
                    pass

                try:
                    depth_int = int(DialogMisura[2])
                    depth_float = float(depth_int/100.0)
                except ValueError:
                    QMessageBox.warning(self.iface.mainWindow(), "Warning",
                                        "DEPTH: Incorrect value. \nDepth value must be integer [cm].")
                    self.Logs("Incorrect Depth value {}".format(DialogMisura[2]))
                    return False
                if depth_int == 0:
                    QMessageBox.warning(self.iface.mainWindow(), "Warning",
                                        "DEPTH: Incorrect value. \nZero values of depth are not accepted.")
                    self.Logs("Incorrect Depth value {}".format(DialogMisura[2]))
                    return False

                try:
                    vel_float = float(DialogMisura[1])
                except ValueError:
                    QMessageBox.warning(self.iface.mainWindow(), "Warning",
                                        "VELOCITY: Incorrect value. \nDecimal separator must be point.")
                    self.Logs("Incorrect Velocity value {}".format(DialogMisura[1]))
                    return False
            else:
                return
            
        #x = SD * SIN(90 - INC) * SIN(AZ)
        #y = SD * SIN(90 - INC) * COS(AZ)
        #z = SD * COS(90 - INC)
        # Python implementa la funzione seno e coseno solo per lavorare in radianti. la funzione per convertire i gradi in radianti è
        # GRADI * 2 * PI / 360

        # fix_print_with_import
        print((SDdistanza, INClinazione, AZimuth, pinpointstring))
        if SDdistanza is not None and INClinazione is not None and AZimuth is not None :
            x = (SDdistanza/1.0) * math.sin((90 - INClinazione) * 2.0 * math.pi / 360.0) * math.sin(AZimuth * 2.0 * math.pi / 360.0)
            y = (SDdistanza/1.0) * math.sin((90 - INClinazione) * 2.0 * math.pi / 360.0) * math.cos(AZimuth * 2.0 * math.pi / 360.0)
            z = (SDdistanza/1.0) * math.cos((90 - INClinazione) * 2.0 * math.pi / 360.0)   
        else:
            x = float(pinpointstring.split('_')[0])
            y = float(pinpointstring.split('_')[1])
            z = 0.
        fet = QgsFeature()
        if SDdistanza is not None and INClinazione is not None and AZimuth is not None :
            fet.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(Xorigine + x, Yorigine + y)))

        else:
            fet.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x, y)))

        #QUI A PRESCINDERE DALLA CONFERMA IL PUNTO VIENE INSERITO E SALVATO
        try:

            if self.chkStazione.isChecked():
                # AGGIUNGO IL RECORD RELATIVO ALLA STAZIONE
                # fet.setAttributes([idNumeroStazioni, DialogStazione[4], '0', SDdistanza, AZimuth, INClinazione, 0, x, y, z, idPoligonoCorrente])
                # rimossi i campi HD  e id da attribute table e spostato campo COMMENT nell'ultima posizione
                fet.setAttributes(
                    [idNumeroStazioni, '0', SDdistanza, AZimuth, INClinazione, x, y, z, DialogStazione[4]])
                v3.addFeatures([fet])

                self.DeletePointButton.setEnabled(True)

            elif self.chkVertice.isChecked():
                # AGGIUNGO IL RECORD RELATIVO AL VERTICE
                my_id = 0 if FIX_BRUTALE else fet.id()
                # my_list = [idPoligonoCorrente, '', idVertice, 0, 0.0, '', 'False', '',
                #           SDdistanza, AZimuth, INClinazione, 0, x, y, z, my_id, idPoligonoCorrente]
                my_list = [idPoligonoCorrente, idVertice, SDdistanza, AZimuth, INClinazione, round(x, 3), round(y, 3),
                           round(z, 3)]
                fet.setAttributes(my_list)
                idVertice = idVertice + 1
                NumeroVerticiRelativiAlPoligono = NumeroVerticiRelativiAlPoligono + 1
                # poligono.append(QgsPoint(Xorigine + ((x - Xorigine)/10000), Yorigine + ((y - Yorigine)/10000)))
                poligono.append(QgsPointXY(Xorigine + x, Yorigine + y))

                if ZMaxPoligono < z:
                    ZMaxPoligono = z
                if ZMinPoligono > z:
                    ZMinPoligono = z
                self.DeletePointButton.setEnabled(True)
                if NumeroVerticiRelativiAlPoligono > 3:
                    self.cmdChiudiPoligonoCorrente.setEnabled(True)

                v4.addFeatures([fet])
                self.Logs("VERTEX drawn correctly")

            else:
                # AGGIUNGO IL RECORD RELATIVO ALLA MISURAZIONE
                my_id = 0 if FIX_BRUTALE else fet.id()
                # fet.setAttributes([PoligonoCorrente,TipoPoligonoCorrente,DialogMisura[0],
                #                    depth_int,vel_float,DialogMisura[3],DialogMisura[4],
                #                    DialogMisura[8],SDdistanza,AZimuth,INClinazione,
                #                    0,round(x, 3),round(y, 3),round(z, 3),my_id, idPoligonoCorrente])

                # rimossi campi non necessari e spostato campo COMMENT all'ultima colonna della attribute table
                fet.setAttributes([PoligonoCorrente,
                                   TipoPoligonoCorrente,
                                   DialogMisura[0],
                                   depth_float,  # DEPTH
                                   vel_float,  # VELOCITY
                                   DialogMisura[3],
                                   DialogMisura[4],
                                   SDdistanza,
                                   AZimuth,
                                   INClinazione,
                                   round(x, 3),
                                   round(y, 3),
                                   round(z, 3),
                                   DialogMisura[8]])
                idPunto = idPunto + 1
                self.DeletePointButton.setEnabled(True)
                layer_1.addFeatures([fet])
                self.Logs("MEAS drawn correctly")

        except:
            self.Logs("Error detected in drawing point")

            # COMMIT DELLE MODIFICHE
        if self.chkStazione.isChecked():
            v3.commitChanges()
            v3.updateExtents()
            self.SalvataggioDatiInShapeFile(v3, "STATION")
        elif self.chkVertice.isChecked():
            v4.commitChanges()
            v4.updateExtents()
            self.SalvataggioDatiInShapeFile(v4, "VERTEX")
        else:
            layer_1.commitChanges()
            layer_1.updateExtents()
            self.SalvataggioDatiInShapeFile(layer_1, "MEAS")


        #SE 'YES' NON SUCCEDE NULLA, IL PUNTO è GIà STATO SALVATO, SE 'NO' ELIMINARE PUNTO
        reply = QMessageBox.question(self, 'Message', 'Confirm point?', QMessageBox.Yes, QMessageBox.No)
        if reply == QMessageBox.No:
            self.RimuoviUltimoPuntoDaLayer()
            #TESTARE SE NECESSARIO
            #self.aggiornaUltimoVertice()
            #self.aggiornaUltimoVerticeEliminato()
        elif reply == QMessageBox.Yes:

            # winsound.Beep(440, 250)
            if self.chkStazione.isChecked():
                self.Logs("STATION drawn correctly")
            elif self.chkVertice.isChecked():
                self.Logs("VERTEX drawn correctly")
            else:
                self.Logs("MEAS drawn correctly")

    def aggiornaUltimoVertice(self, fid):
        global idUltimoVertice
        _msg = "updating last vertex fid: {}".format(fid)
        self.Logs(_msg)
        idUltimoVertice = fid

    # updates fid of last summit eliminated, and dates back to the previous one (-1)
    def aggiornaUltimoVerticeEliminato(self, fid):
        global idUltimoVertice
        _msg = "updating last vertex fid: {}".format(fid)
        self.Logs(_msg)
        idUltimoVertice = fid - 1

    def CreaNuovoPoligono(self):
        global poligono
        global cPoligono
        global idPoligonoCorrente
        poligono = [] 
        cPoligono = []
        idPoligonoCorrente = idPoligonoCorrente + 1

    def getVectorLayerByName(self, layerName): 
        layerMap = QgsProject.instance().mapLayers()
        for name, layer in layerMap.items(): 
            if layer.name() == layerName: 
                if layer.isValid(): 
                    return layer 
                else: 
                    return None

    def SelezionaPoligono(self, selFeatures):
        global v2
        global PoligonoCorrente
        global TipoPoligonoCorrente
        global layer_1
        global idPunto
        try:
            pol = v2.selectedFeatures()
            attr = pol[0].attributes()
            PoligonoCorrente = attr[0]
            TipoPoligonoCorrente = attr[1]
            features = layer_1.getFeatures()
            n_punti = 0
            for f in features:
                attr = f.attributes()
                if attr[0] is PoligonoCorrente:
                    n_punti = n_punti + 1
            idPunto = n_punti + 1
        except:
            self.Logs("Error during polygon selection/unselection")

    def SalvataggioDatiInShapeFile(self, layer, tipo):
        global pathFileHMU
        global pathFileVERTEX
        global pathFileMEAS
        global pathFileSTATION
        if tipo == "MEAS":
            pathFile = pathFileMEAS
        elif tipo == "VERTEX":
            pathFile = pathFileVERTEX
        elif tipo == "HMU":
            pathFile = pathFileHMU
        else:
            pathFile = pathFileSTATION
        try:
            self.Logs("Saving shapefile: {}".format(pathFile))
            options = QgsVectorFileWriter.SaveVectorOptions()
            options.driverName = "ESRI Shapefile"
            options.fileEncoding = "CP1250"
            transform_context = QgsProject.instance().transformContext()
            errCode, errMsg = QgsVectorFileWriter.writeAsVectorFormatV2(layer, pathFile, transform_context, options)
            if errCode == QgsVectorFileWriter.NoError:
                self.Logs("Saved shapefile: {}".format(pathFile))
            else:
                raise Exception(errMsg)
        except:
            self.Logs("Failed to save the shapefile")

    def CreaNuovoLayer(self, tipo):
        # CREA IL LAYER
        global layer_1
        global v2
        global v3
        global v4
        global pathFileHMU
        global pathFileVERTEX
        global pathFileMEAS
        global pathFileSTATION
        global pathFileProgettoQGIS
        global punti
        global punti_posizione_telemetro
        global idLayerPoligoni
        global idPoligonoCorrente
        global PoligonoCorrente
        global TipoPoligonoCorrente
        global Xorigine
        global Yorigine
        global idPunto
        global idVertice
        global idNumeroStazioni
        global NumeroVerticiRelativiAlPoligono
        global boolDummyStation
        global ZMaxPoligono
        global ZMinPoligono
        global RSSelezionata
        if tipo != "OPEN":
            # CREAZIONE DEL PROGETTO QGIS CON COPIA DEL FILE DI GESTIONE DEL DISEGNO MANUALE DEI PUNTI
            #QgsApplication.initQgis()
            QgsProject.instance().setFileName(pathFileProgettoQGIS)
            QgsProject.instance().write()
            boolDummyStation = True
        else:
            boolDummyStation = False
        idPoligonoCorrente = 0
        PoligonoCorrente = 0
        TipoPoligonoCorrente = ""
        idPunto = 1
        idVertice = 1
        NumeroVerticiRelativiAlPoligono = 1
        idNumeroStazioni = 1
        ZMaxPoligono = -9999
        ZMinPoligono = 9999
        stazione = []
        idLayerPoligoni = "NESSUN NOME"
        punti = []
        punti_posizione_telemetro = []
        #CREA I LAYER CON INFO CRS
        stringa_crs_point = 'point?crs={}'.format(RSSelezionata)
        stringa_crs_multip = 'multipolygon?crs={}'.format(RSSelezionata)
        layer_1 = QgsVectorLayer(stringa_crs_point, 'MEAS' , "memory")
        v2 = QgsVectorLayer(stringa_crs_multip, "HMU" , "memory")
        v3 = QgsVectorLayer(stringa_crs_point, 'STATION' , "memory")
        v4 = QgsVectorLayer(stringa_crs_point, 'VERTEX' , "memory")

        pr = layer_1.dataProvider()
        pr2 = v2.dataProvider()
        pr3 = v3.dataProvider()
        pr4 = v4.dataProvider()
        # ATTIVA LA MODALITA MODIFICA DEI LAYER
        layer_1.startEditing()
        v2.startEditing()
        v3.startEditing()
        v4.startEditing()
        # CREA IL RECORD
        #MEAS
        pr.addAttributes([QgsField("HMU_NUM", QVariant.Int),
                          QgsField("HMU_TYPE", QVariant.String, "", 20),
                          QgsField("PNTNUM", QVariant.Int),
                          QgsField("DEPTH", QVariant.Double),
                          QgsField("VELOCITY", QVariant.Double),
                          QgsField("SUBSTRATE", QVariant.String, "", 25),
                          QgsField("ESTIMATED", QVariant.String, "", 5),
                          QgsField("SD", QVariant.Double),
                          QgsField("AZ", QVariant.Double),
                          QgsField("INC", QVariant.Double),
                          #QgsField("HD", QVariant.Double),
                          QgsField("X", QVariant.Double),
                          QgsField("Y", QVariant.Double),
                          QgsField("Z", QVariant.Double),
                          QgsField("COMMENT", QVariant.String, "", 500)])
                          #QgsField("id", QVariant.Int),
                          #QgsField("idPoligono", QVariant.Int)])

        #HMU
        pr2.addAttributes([QgsField("HMU_NUM", QVariant.Int),
                          QgsField("HMU_TYPE", QVariant.String, "", 20),
                          QgsField("Z_MAX", QVariant.Double),
                          QgsField("Z_MIN", QVariant.Double),
                          QgsField("CONNECTIV", QVariant.String, "", 5),
                           QgsField("BOULDER", QVariant.String, "", 5),
                           QgsField("CANOP_SHAD", QVariant.String, "", 5),
                          QgsField("OVERHA_VEG", QVariant.String, "", 5),
                          QgsField("ROOTS", QVariant.String, "", 5),
                          QgsField("SUBMER_VEG", QVariant.String, "", 5),
                          QgsField("EMERG_VEG", QVariant.String, "", 5),
                          QgsField("UNDERC_BAN", QVariant.String, "", 5),
                          QgsField("WOODY_DEBR", QVariant.String, "", 5),
                          QgsField("RIPRAP", QVariant.String, "", 5),
                          QgsField("SHALL_MARG", QVariant.String, "", 5),
                          QgsField("COMMENT", QVariant.String, "", 500)])
        #VERTEX
        pr4.addAttributes([QgsField("HMU_NUM", QVariant.Int),
                          #QgsField("HMU_TYPE", QVariant.String, "", 10),
                          QgsField("PNTNUM", QVariant.Int),
                          #QgsField("DEPTH", QVariant.Int),
                          #QgsField("VELOCITY", QVariant.Double),
                          #QgsField("SUBSTRATE", QVariant.String, "", 25),
                          #QgsField("ESTIMATED", QVariant.String, "", 5),
                          #QgsField("COMMENT", QVariant.String, "", 500),
                          QgsField("SD", QVariant.Double),
                          QgsField("AZ", QVariant.Double),
                          QgsField("INC", QVariant.Double),
                          #QgsField("HD", QVariant.Double),
                          QgsField("X", QVariant.Double),
                          QgsField("Y", QVariant.Double),
                          QgsField("Z", QVariant.Double)])
                          #QgsField("id", QVariant.Int),
                          #QgsField("idPoligono", QVariant.Int)])
        #STATION
        pr3.addAttributes([QgsField("NSTAZ", QVariant.Int),
                           QgsField("CURRENT", QVariant.String, "", 1),
                           QgsField("SD", QVariant.Double),
                           QgsField("AZ", QVariant.Double),
                           QgsField("INC", QVariant.Double),
                           #QgsField("HD", QVariant.Double),
                           QgsField("X", QVariant.Double),
                           QgsField("Y", QVariant.Double),
                           QgsField("Z", QVariant.Double),
                           QgsField("COMMENT", QVariant.String, "", 500)])
                           #QgsField("id", QVariant.Double)])

        if tipo != "OPEN":
            # # AGGIUNGE IL PRIMO PUNTO
            # Xorigine = 5
            # Yorigine = 5
            # fet = QgsFeature()
            # fet.setGeometry(QgsGeometry.fromPoint(QgsPoint(Xorigine,Yorigine)))
            # fet.setAttributes([1, "DUMMY STATION", "0", 0.0, 0.0, 0.0, 0.0, Xorigine, Yorigine, 0, fet.id()])
            # idNumeroStazioni = idNumeroStazioni + 1
            # pr3.addFeatures([fet])
            self.chkStazione.setChecked(True)
            self.enable_buttons()

        # Define a lookup for VERTEX (color, size)
        v4.renderer().symbol().setSize(3)
        v4.renderer().symbol().setColor(QColor('#65dbe8'))
        v4.triggerRepaint()

        # Define a lookup for MEAS (color, size)
        layer_1.renderer().symbol().setSize(3)
        layer_1.renderer().symbol().setColor(QColor('#c0c0c0'))
        layer_1.triggerRepaint()



        # Define a lookup for STATION (color, size, label)
        tipodistazione = {
            '1': ('#f00', 5, 'SELECTED'),
            '': ('#ffdc70', 4, ''),
        }
        # create a category for each item in animals
        categoriedistazione = []
        # create the renderer and assign it to a layer
        expressionstazione = 'CURRENT' # field name
        for tipostazione, (color, size, label) in list(tipodistazione.items()):
            symbolstazione = QgsSymbol.defaultSymbol(v3.geometryType())
            symbolstazione.setColor(QColor(color))
            symbolstazione.setSize(size)
            categoriadistazione = QgsRendererCategory(tipostazione, symbolstazione, label)
            categoriedistazione.append(categoriadistazione)

        # Define a lookup for POLYGONS
            # COPIATO da sopra
            suit_color = {"POTHOLE": ('#000000', "POTHOLE"),
                          "CASCADE": ('#9900CC', "CASCADE"),
                          "RAPID": ('#0000ff', "RAPID"),
                          "RIFFLE": ('#66FFFF', "RIFFLE"),
                          "STEP": ('#ff0000', "STEP"),
                          "POOL": ('#ffff00', "POOL"),
                          "GLIDE": ('#00ff00', "GLIDE"),
                          "DUNE": ('#8220A5', "DUNE"),
                          "AQUAT_VEG": ('#274e13', "AQUAT_VEG"),
                          "SEC_CHAN": ('#99FF99', "SEC_CHAN"),
                          "FLOOD_LAKE": ('#003366', "FLOOD_LAKE"),
                          "WETLAND": ('#FF9966', "WETLAND"),
                          "ARTIF_ELEM": ('#FFFFFF', "ARTIF_ELEM"),
                          "WATERFALL": ('#999966', "WATERFALL"),
                          "PLUNGE_POOL": ('#FF9900', "PLUNGE_POOL"),
                          "BACKWATER": ('#990033', "BACKWATER"),
                          "ISOL_POND": ('#37aba6', "ISOL_POND"),
                          "ROCK_GLIDE": ('#FF33CC', "ROCK_GLIDE"),
                          "HYDR_UNIT": ('#32C8C8', "HYDR_UNIT")
                          }

        # create the renderer and assign it to a layer
        expression = "HMU_TYPE"  # field name
        props = {'color': '255, 0, 0', 'style': 'solid'}
        categories = []
        for hmu_type, (color, label) in list(suit_color.items()):
            symbol = QgsSymbol.defaultSymbol(v2.geometryType())
            symbol.setColor(QColor(color))
            category = QgsRendererCategory(hmu_type, symbol, label)
            categories.append(category)

        idLayerPoligoni = v2.name()
        s = QgsFillSymbol.createSimple(props)
        v2.setRenderer(QgsCategorizedSymbolRenderer(expression, categories))
        v2.setMinimumScale(1.0)
        v2.setMaximumScale(1000.0)
        # v2.setEditorLayout(QgsVectorLayer.UiFileLayout)
        # v2.setEditForm(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + 'python/plugins/mapstream/poligoni.ui')
        # v2.setEditFormInit("RecuperoDati.Poligoni")
        v2.selectionChanged.connect(self.SelezionaPoligono)
        # ASSOCIO LA SCALA AI LAYER
        # layer_1.setEditorLayout(QgsVectorLayer.UiFileLayout)
        # layer_1.setEditForm(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + 'python/plugins/mapstream/misure.ui')
        # layer_1.setEditFormInit("RecuperoDati.Misure")
        layer_1.setMinimumScale(1.0)
        layer_1.setMaximumScale(1000.0)
        # v3.setEditorLayout(QgsVectorLayer.UiFileLayout)
        # v3.setEditForm(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + 'python/plugins/mapstream/stazioni.ui')
        # v3.setEditFormInit("RecuperoDati.Stazioni")
        rstazione = QgsCategorizedSymbolRenderer(expressionstazione, categoriedistazione)
        v3.setRenderer(rstazione)
        v3.setMinimumScale(1.0)
        v3.setMaximumScale(1000.0)
        # v4.setEditorLayout(QgsVectorLayer.UiFileLayout)
        # v4.setEditForm(QFileInfo(QgsApplication.qgisSettingsDirPath()).path() + 'python/plugins/mapstream/misure.ui')
        v4.setMinimumScale(1.0)
        v4.setMaximumScale(1000.0)
        # COMMINT DELLE MODIFICHE
        layer_1.commitChanges()
        layer_1.updateExtents()
        v2.commitChanges()
        v2.updateExtents()
        v3.commitChanges()
        v3.updateExtents()
        v4.commitChanges()
        v4.updateExtents()
        # ASSOCIO AL LAYER DEI PUNTI LA FUNZIONE CHE SI ATTIVA IN FASE DI MODIFICA DELLA POSIZIONE DI UN PUNTO
        layer_1.layerModified.connect( self.SalvaModificheManualiPuntiV1 )
        v2.layerModified.connect( self.SalvaModificheManualiPuntiV2 )
        v3.layerModified.connect( self.SalvaModificheManualiPuntiV3 )
        v4.layerModified.connect( self.SalvaModificheManualiPuntiV4 )
        v4.featureAdded.connect(self.aggiornaUltimoVertice)
        v4.featureDeleted.connect(self.aggiornaUltimoVerticeEliminato)

        # AGGIUNGE IL LAYER ALLA LEGENDA
        QgsProject.instance().addMapLayer(v2)
        QgsProject.instance().addMapLayer(layer_1)
        QgsProject.instance().addMapLayer(v3)
        QgsProject.instance().addMapLayer(v4)
        if tipo != "OPEN":
            self.SalvataggioDatiInShapeFile(layer_1, "MEAS")
            self.SalvataggioDatiInShapeFile(v3, "STATION")
            self.SalvataggioDatiInShapeFile(v4, "VERTEX")
        self.CreaNuovoPoligono()

    # if close application
    def closeEvent(self, event):
        # global v3
        # global v4
        # global layer_1

        reply = QMessageBox.question(
            self, "Message",
            "Are you sure you want to quit? Any unsaved work will be lost.", QMessageBox.Close | QMessageBox.Cancel)
        if reply == QMessageBox.Close:


            # quando esco dal plugin chiudo il threadgenero file txt meas
            # os.path.join()
            # meas_txt_file = open("Measurements.txt", 'w')
            # for feat in layer_1.getFeatures():
            #     msgout = '%s, %s, %d, %f, %f, %s\n' % (feat["HMU_NUM"],
            #                                            feat["HMU_TYPE"],
            #                                            feat["PNT_NUM"],
            #                                            feat["DEPTH"] / 100,
            #                                            feat["VELOCITY"],
            #                                            feat["SUBSTRATE"])
            #     unicode_message = msgout.encode('utf-8')
            #     meas_txt_file.write(unicode_message)
            # meas_txt_file.close()

            if self.ble_scanner_thread and self.ble_scanner_thread.isRunning():
                self.ble_scanner_thread.abort()
                self.ble_scanner_thread.wait()
                self.ble_scanner_thread.deleteLater()

            self.stopReading()

            self.ClosePinPointing()

            if not IS_BLE_VERSION:
                self.closeThread()

            self.Logs('Closing MapStream')
            # self.timer.stop()

            event.accept()


            self.close()
            # salvo il txt
            self.save_txt()

        else:
            event.ignore()

    def save_txt(self):
        # Ottieni il layer attivo
        # layer = self.iface.activeLayer()
        # print("QUI"*50)
        # print(layer)
        # if not layer or not isinstance(layer, QgsVectorLayer):
        #     self.iface.messageBar().pushMessage("Errore",
        #                                         "Seleziona uno shapefile valido", level=1)
        #     return
        #
        # Ottieni il percorso del file DBF
        # layer_source = layer.source()
        # print(layer_source)
        # print(os.path(layer_source))
        # dbf_path = os.path.splitext(layer_source)[0] + '.dbf'
        # print(dbf_path)

        '''
        percorso inizializzato nell'open oppure dopo aver salavato il file
        '''
        # print(f"self.dir_path = {self.dir_path}")


        if self.dir_path:

            files = os.listdir(self.dir_path)

            # Filter files that contain "MEAS" in their name and have a .dbf extension
            meas_dbf_files = [file for file in files if "MEAS" in file and file.endswith(".dbf")]

            # Check if more than one file is found
            if len(meas_dbf_files) > 1:
                raise Exception("More than one .dbf file containing 'MEAS' found.")
            elif len(meas_dbf_files) == 0:
                raise Exception("No .dbf file containing 'MEAS' found.")

            # Return the found file
            dbf_path = os.path.join(self.dir_path, meas_dbf_files[0])
            print(f"dbf_path = {dbf_path}")

            if not os.path.exists(dbf_path):
                self.iface.messageBar().pushMessage("Errore",
                                                    "File DBF non trovato", level=1)


            try:
                from dbfread import DBF
                # Leggi il file DBF
                dbf = DBF(dbf_path) # pd.read_dbf(dbf_path)

                df = pd.DataFrame(list(dbf))

                # Seleziona solo le prime 5 colonne
                df_for_ssw = df.iloc[:, 0:6]

                # Crea il percorso per il file TXT
                txt_path = os.path.splitext(dbf_path)[0] + '.txt'




                # Salva in formato txt (delimitato da tabulazione)
                df_for_ssw.to_csv(txt_path, sep='\t', index=False)

                self.iface.messageBar().pushMessage("Successo",
                                                    f"File salvato in: {txt_path}", level=3)

                # Leggi il file DBF
                # table = dbfread.DBF(dbf_path)

                # Crea il percorso per il file TXT
                # txt_path = os.path.splitext(dbf_path)[0] + '.txt'

                # Scrivi i dati in formato TXT
                # with open(txt_path, 'w', newline='') as txt_file:
                #     writer = csv.writer(txt_file, delimiter='\t')

                    # Scrivi l'intestazione
                    # writer.writerow(table.field_names[:5])

                    # Scrivi i record
                    # for record in table:
                    #     writer.writerow(record.values())

                # self.iface.messageBar().pushMessage("Successo",
                #                                     f"File salvato in: {txt_path}", level=3)

            except Exception as e:
                self.iface.messageBar().pushMessage("Errore",
                                                    f"Errore durante il salvataggio: {str(e)}", level=1)
        else:
            self.Logs("No directory selected, impossible save MEAS txt file.")



    ####################################################################################################################
    ####################################################################################################################
    ############################################## COM CONNECTION ######################################################
    ####################################################################################################################
    ####################################################################################################################
    '''
    def COM_connection(self, port_text):

        if self.ser != None:
            self.ser.close()
            self.ser = None
        if (self.__thread != None) & (self.__receiver != None):
            self.closeThread()
            self.__thread = None
            self.__receiver = None
        if port_text == "" or port_text == " " or not port_text:
            self.connection_label(3, port_text)
        if port_text == self.scan_text:
            self.ElencoPorteCom.clear()
            self.connection_label(5, "")
            QApplication.processEvents()  # aggiorno l'interfaccia perchè se no non riesco a vedere la scritta blu
            services, services_lookups = scan_services()
            self.combo_complete = services
            self.services_lookups = services_lookups
            self.combo_complete.insert(0, "")
            self.ElencoPorteCom.addItems(self.combo_complete)
            self.connection_label(3, self.ElencoPorteCom.currentText())

        else:
            # scrivo la COM scelta nel formato che vuole la lib serial
            try:
                s_port = str(self.services_lookups[port_text])
            except KeyError:
                self.Logs("Unrecognized port selected")
                self.connection_label(3, None)
                return
            self.connection_label(2, s_port)
            QApplication.processEvents()  # aggiorno l'interfaccia perchè se no non riesco a vedere la scritta blu
            kwargs = {
                'port': s_port,
                'baudrate': 9600,
                'parity': serial.PARITY_NONE,
                'stopbits': serial.STOPBITS_ONE,
                'bytesize': serial.EIGHTBITS,
                'timeout': 0, }
            try:
                # tento la connessione alla seriale
                self.ser = serial.Serial(**kwargs)
                # se va la chiudo subito e creo il thread a partire dalla classe esterna SerialThread
                self.ser.close()
                # creo il QThread
                self.__thread = QThread(self)
                self.__receiver = SerialThread(s_port)
                self.__receiver.moveToThread(self.__thread)
                # SIGNAL della classe SerialThread che mi consente di riportare di qua il valore dal telemetro
                self.__receiver.thread2gui_signal.connect(self.Decifra_Disegna)
                self.__thread.started.connect(self.__receiver.run)
                # Lancio il thread
                self.__thread.start()
                # scritta verde connected
                self.connection_label(0, s_port)
                self.Logs("Connected on port: {}".format(s_port))
            except:
                # la COM scelta non risponde
                self.closeThread()
                # scritta rossa unconnected
                self.connection_label(1, s_port)
                _msg = "Connection interrupted on port: {}".format(s_port)
                self.Logs(_msg)
        
        
            def refresh_COM_connection(self):
        if self.__thread:
            if not self.__thread.isRunning():
                if not self.ElencoPorteCom.currentText() == "":
                    self.COM_connection(self.ElencoPorteCom.currentText())
                    
'''
    def hide_show_manual_meas(self):
        if self.manualmeascheckBox.isChecked() == True:
            self.lblTestoX.show()
            self.lblTestoY.show()
            self.lblTestoZ.show()
            self.txtValoreX.show()
            self.txtValoreX_2.show()
            self.txtValoreX_3.show()
            self.cmdPloti.show()
        if self.manualmeascheckBox.isChecked() == False:
            self.lblTestoX.hide()
            self.lblTestoY.hide()
            self.lblTestoZ.hide()
            self.txtValoreX.hide()
            self.txtValoreX_2.hide()
            self.txtValoreX_3.hide()
            self.cmdPloti.hide()


    def DisegnaPunto(self):
        global tmpSD
        global tmpAZ
        global tmpINC
        global idLayerPoligoni
        global idPoligonoCorrente
        global PoligonoCorrente
        if self.chkMisura.isChecked() and idLayerPoligoni == "NESSUN NOME":
            QMessageBox.information(self, 'MEASURE', 'No polygon selected', QMessageBox.Ok)
            PoligonoCorrente = idPoligonoCorrente
        tmpSD = 0.0
        tmpAZ = 0.0
        tmpINC = 0.0
        if self.txtValoreX.toPlainText() == "":
            self.txtValoreX.setText("0")
        if self.txtValoreX_2.toPlainText() == "":
            self.txtValoreX_2.setText("0")
        if self.txtValoreX_3.toPlainText() == "":
            self.txtValoreX_3.setText("0")
        tmpSD = float(self.txtValoreX.toPlainText())
        tmpAZ = float(self.txtValoreX_2.toPlainText())
        tmpINC = float(self.txtValoreX_3.toPlainText())
        self.DisegnaPuntoSuLayer(float(self.txtValoreX.toPlainText()), float(self.txtValoreX_2.toPlainText()), float(self.txtValoreX_3.toPlainText()))

        
    def Decifra_Disegna(self, bt_string):
        global tmpSD
        global tmpAZ
        global tmpINC
        global idLayerPoligoni
        global idPoligonoCorrente
        global idNumeroStazioni
        global PoligonoCorrente
        if (layer_1 != None) & (v2 != None) & (v3 != None) & (v4 != None):
            if self.chkMisura.isChecked() and idLayerPoligoni == "NESSUN NOME":
                QMessageBox.information(self, 'MEASURE', 'No polygon selected', QMessageBox.Ok)
                PoligonoCorrente = idPoligonoCorrente
            tmpSD = 0.0
            tmpAZ = 0.0
            tmpINC = 0.0
            if bt_string.split('@')[0] == "":
                self.txtValoreX.setText("0")
            if bt_string.split('@')[1] == "":
                    self.txtValoreX_2.setText("0")
            if bt_string.split('@')[2] == "":
                self.txtValoreX_3.setText("0")
            tmpSD = float(bt_string.split('@')[0])
            tmpAZ = float(bt_string.split('@')[1])
            tmpINC = float(bt_string.split('@')[2])           
            self.DisegnaPuntoSuLayer(float(bt_string.split('@')[0]), float(bt_string.split('@')[1]), float(bt_string.split('@')[2]))
            self.Logs("Point drawn correctly")
            time.sleep(0.1)
        else:
            self.Logs("Bluetooth signal received, but no layers detected")
''' 
    def connection_label(self, cn_type, port):
        cnn_status = {
            0: ("green", "Connected"),
            1: ("red", "Unconnected"),
            2: ("blue", "Connecting"),
            3: ("black", "Select a COM port"),
            4: ("black", "Not yet initialized"),
            5: ("blue", "Scanning devices")
        }
        if cn_type <= 2:
            self.CnnStatusLabel.setText("{} ({})".format(cnn_status[cn_type][1], port))
        else:
            self.CnnStatusLabel.setText(cnn_status[cn_type][1])
        self.CnnStatusLabel.setStyleSheet('color: {}'.format(cnn_status[cn_type][0]))

    def closeThread(self):
        if self.__receiver:
            self.__receiver.stop()
        if self.__thread:
            #chiusura del thread
            self.__thread.quit()
            self.__thread.wait()
            self.Logs('Thread closed correctly')


        '''