#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import absolute_import
from .config import config as cfg
from os import sep
# This script initializes the plugin, making it known to QGIS.

def name():
    return cfg.plugin_name()

def version():
    return cfg.plugin_version()

def experimental():
    return cfg.experimental_plugin()

def qgisMinimumVersion():
    """development was based on 1.7 API"""
    return cfg.qgisMinimumVersion()

def description():
    """description shown in qgis plugin manager"""
    return cfg.plugin_description()

def icon():
    """icon shown in qgis plugin manager"""
    return cfg.icons()["folder_name"] + os.sep + cfg.icons()["icon_file"] 

def authorName():
	return cfg.authorName()

def classFactory(iface):
    """Load Plugin class from file mapstream and returns the class to qgis interface"""
    from .mapstream import MapStream
    return MapStream(iface)
