#!/usr/bin/env python
# -*- coding: utf-8 -*-
from builtins import str
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.core import *
from qgis.analysis import *

myDialog = None

def ControlloStato(stato):
    if stato == 0:
        return "False"
    elif stato == 1:
        return "-"
    else:
        return "True"

def LeggiValoreMeas(nome):
    global myDialog
    valore = ""
    if myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Gigalithal (Rocks)':
        valore = 'GIGALITHAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Megalithal (M40)':
        valore = 'MEGALITHAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Macrolithal (20-40)':
        valore = 'MACROLITHAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Mesolithal (6-20)':
        valore = 'MESOLITHAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Microlithal (2-6)':
        valore = 'MICROLITHAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Akal (Gravel)':
        valore = 'AKAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Psammal (Sand)':
        valore = 'PSAMMAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Pelal (Clay)':
        valore = 'PELAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Detritus (Organic)':
        valore = 'DETRITUS'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Xylal (Dead wood)':
        valore = 'XYLAL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Sapropel (Sludge)':
        valore = 'SAPROPEL'
    elif myDialog.findChild(QComboBox, "_" + nome).currentText() == 'Phytal (Moss, fungi)':
        valore ='PHYTAL'
    myDialog.findChild(QLineEdit, nome).setText(valore)




def LeggiValore(nome):
    global myDialog
    myDialog.findChild(QLineEdit, nome).setText(myDialog.findChild(QComboBox, "_" + nome).currentText())
    
def Controllo(nome):
    global myDialog
    chNome = "_" + nome
    myDialog.findChild(QLineEdit, nome).setText(ControlloStato(myDialog.findChild(QCheckBox, chNome).checkState()))

def Misure(dialog, layerid, featureid):
    global myDialog
    myDialog = dialog
    # recupero i layers attivi e cerco i due che contengono punti e poligoni
    layer = list(QgsMapLayerRegistry.instance().mapLayers().values())
    ll = None   # contiene i poligoni
    lp = None   # contiene i punti

    for l in layer:
        # recupero il layer che contiene i poligoni
        if l.name() == "HMU":
            ll = l
        # recupero il layer che contiene i punti
        if l.name() == "MEAS":
            lp = l
    # recupero l'elenco completo dei punti presenti sul layer delle misure
    punti = lp.getFeatures()
    # progressivo locale al poligono
    maxpunto = 0
    if ll is None:
        # caso in cui non ci sia un layer di sequenze morfologiche ma che si voglia comunque registrare delle misurazioni
        for p in punti:
            # per ogni punto prendo l'elenco degli attributi
            puntiAttr = p.attributes()
            if maxpunto < puntiAttr[2]:
                #prendo il massimo tra i due
                maxpunto = puntiAttr[2]

        dialog.findChild(QLineEdit, "HMU_NUM").setText("0")
        dialog.findChild(QLineEdit, "HMU_TYPE").setText("")
    else:
        # considero solo il poligono selezionato
        pol = ll.selectedFeatures()
        if len(pol) > 0:
            # recupero l'elenco degli attributi del poligono selezionato per recuperare il progressivo e il tipo
            attr = pol[0].attributes()
            for p in punti:
                # per ogni punto prendo l'elenco degli attributi
                puntiAttr = p.attributes()
                #se il punto appartiene al poligono
                if puntiAttr[0] == attr[0]:
                    #controllo che il progressivo del punto corrente sia maggiore del progressivo temporaneo
                    if maxpunto < puntiAttr[2]:
                        #prendo il massimo tra i due
                        maxpunto = puntiAttr[2]
            dialog.findChild(QLineEdit, "HMU_NUM").setText(str(attr[0]))
            dialog.findChild(QLineEdit, "HMU_TYPE").setText(str(attr[1]))
        else:
            # in caso non sia stato selezionato alcun poligono faccio continuare ma
            # segnalo nel commento che nessun poligono e' stato assegnato
            for p in punti:
                # per ogni punto prendo l'elenco degli attributi
                puntiAttr = p.attributes()
                if maxpunto < puntiAttr[2]:
                    #prendo il massimo tra i due
                    maxpunto = puntiAttr[2]

            dialog.findChild(QLineEdit, "HMU_NUM").setText("0")
            dialog.findChild(QLineEdit, "HMU_TYPE").setText("")
            dialog.findChild(QTextBrowser, "COMMENT").setText("No polygon selected")


    dialog.findChild(QLineEdit, "ESTIMATED").setText("False")
    dialog.findChild(QLineEdit, "PNT_NUM").setText(str(int(maxpunto) + 1))
    dialog.findChild(QComboBox, "_SUBSTRATE").currentIndexChanged.connect(lambda: LeggiValoreMeas("SUBSTRATE"))
    dialog.findChild(QCheckBox, "_ESTIMATED").stateChanged.connect(lambda: Controllo("ESTIMATED"))
    dialog.findChild(QCheckBox, "_ESTIMATED").setChecked(False)
    
        
def Poligoni(dialog, layerid, featureid):
    global myDialog
    layer = list(QgsMapLayerRegistry.instance().mapLayers().values())
    ll = None   # contiene le stazioni di rilevamento
    for l in layer:
        # recupero il layer che contiene i poligoni
        if l.name() == "HMU":
            ll = l
    # recupero l'elenco completo delle stazioni presenti sul layer
    punti = ll.getFeatures()
    # progressivo locale al poligono
    maxpunto = 0
    for p in punti:
        # per ogni punto prendo l'elenco degli attributi
        puntiAttr = p.attributes()

        #controllo che il progressivo del punto corrente sia maggiore del progressivo temporaneo
        if maxpunto < puntiAttr[0]:
            #prendo il massimo tra i due
            maxpunto = puntiAttr[0]

    myDialog = dialog
    dialog.findChild(QLineEdit, "HMU_NUM").setText(str(maxpunto+1))
    dialog.findChild(QComboBox, "_HMU_TYPE").currentIndexChanged.connect(lambda: LeggiValore("HMU_TYPE"))

    dialog.findChild(QLineEdit, "OVERHA_VEG").setText("False")
    dialog.findChild(QLineEdit, "CANOP_SHAD").setText("False")
    dialog.findChild(QLineEdit, "ROOTS").setText("False")
    dialog.findChild(QLineEdit, "CONNECTIV").setText("False")
    dialog.findChild(QLineEdit, "UNDERC_BAN").setText("False")
    dialog.findChild(QLineEdit, "SUBMER_VEG").setText("False")
    dialog.findChild(QLineEdit, "RIPRAP").setText("False")
    dialog.findChild(QLineEdit, "BOULDER").setText("False")
    dialog.findChild(QLineEdit, "EMERG_VEG").setText("False")
    dialog.findChild(QLineEdit, "SHALL_MARG").setText("False")
    dialog.findChild(QLineEdit, "WOODY_DEBR").setText("False")

    dialog.findChild(QCheckBox, "_OVERHA_VEG").stateChanged.connect(lambda: Controllo("OVERHA_VEG"))
    dialog.findChild(QCheckBox, "_CANOP_SHAD").stateChanged.connect(lambda: Controllo('CANOP_SHAD'))
    dialog.findChild(QCheckBox, "_ROOTS").stateChanged.connect(lambda: Controllo('ROOTS'))
    dialog.findChild(QCheckBox, "_CONNECTIV").stateChanged.connect(lambda: Controllo('CONNECTIV'))
    dialog.findChild(QCheckBox, "_UNDERC_BAN").stateChanged.connect(lambda: Controllo('UNDERC_BAN'))
    dialog.findChild(QCheckBox, "_SUBMER_VEG").stateChanged.connect(lambda: Controllo('SUBMER_VEG'))
    dialog.findChild(QCheckBox, "_RIPRAP").stateChanged.connect(lambda: Controllo('RIPRAP'))
    dialog.findChild(QCheckBox, "_BOULDER").stateChanged.connect(lambda: Controllo('BOULDER'))
    dialog.findChild(QCheckBox, "_EMERG_VEG").stateChanged.connect(lambda: Controllo('EMERG_VEG'))
    dialog.findChild(QCheckBox, "_SHALL_MARG").stateChanged.connect(lambda: Controllo('SHALL_MARG'))
    dialog.findChild(QCheckBox, "_WOODY_DEBR").stateChanged.connect(lambda: Controllo('WOODY_DEBR'))

    dialog.findChild(QCheckBox, "_OVERHA_VEG").setChecked(False)
    dialog.findChild(QCheckBox, "_CANOP_SHAD").setChecked(False)
    dialog.findChild(QCheckBox, "_ROOTS").setChecked(False)
    dialog.findChild(QCheckBox, "_CONNECTIV").setChecked(False)
    dialog.findChild(QCheckBox, "_UNDERC_BAN").setChecked(False)
    dialog.findChild(QCheckBox, "_SUBMER_VEG").setChecked(False)
    dialog.findChild(QCheckBox, "_RIPRAP").setChecked(False)
    dialog.findChild(QCheckBox, "_BOULDER").setChecked(False)
    dialog.findChild(QCheckBox, "_EMERG_VEG").setChecked(False)
    dialog.findChild(QCheckBox, "_SHALL_MARG").setChecked(False)
    dialog.findChild(QCheckBox, "_WOODY_DEBR").setChecked(False)
    
def Stazioni(dialog,layerid,featureid):
    layer = list(QgsMapLayerRegistry.instance().mapLayers().values())
    ll = None   # contiene le stazioni di rilevamento
    for l in layer:
        # recupero il layer che contiene i poligoni
        if l.name() == "STATIONS":
            ll = l
    # recupero l'elenco completo delle stazioni presenti sul layer
    punti = ll.getFeatures()
    # progressivo locale al poligono
    maxpunto = 0
    prXXX = ll.dataProvider()    
    for p in punti:
        ### per ogni punto prendo l'elenco degli attributi
        ##puntiAttr = p.attributes()

        ###controllo che il progressivo del punto corrente sia maggiore del progressivo temporaneo
        ##if maxpunto < puntiAttr[0]:
        ##    #prendo il massimo tra i due
        ##    maxpunto = puntiAttr[0]
        #attrName = 'CURRENT'
        #p[attrName] = '0'
        #prXXX.changeAttributeValues({p.id() : {prXXX.fieldNameMap()[attrName] : '0'}})
        maxpunto = maxpunto + 1     # mi limito a contare quante stazioni ci sono
    dialog.findChild(QLineEdit, "NSTAZ").setText(str(maxpunto+1))
