@ECHO OFF
CLS
SETLOCAL ENABLEEXTENSIONS ENABLEDELAYEDEXPANSION

REM === Trova installazione OSGeo4W (64 o 32 bit) ===
SET "OSGEO_PATH="

IF EXIST "C:\OSGeo4W64\bin" (
    SET "OSGEO_PATH=C:\OSGeo4W64\bin"
) ELSE IF EXIST "C:\OSGeo4W\bin" (
    SET "OSGEO_PATH=C:\OSGeo4W\bin"
)

IF NOT DEFINED OSGEO_PATH (
    START CMD /C "ECHO Nessuna installazione OSGeo4W trovata. && PAUSE"
    GOTO EXITHERE
)

REM === Trova python-qgis(.bat) ===
IF EXIST "%OSGEO_PATH%\python-qgis.bat" (
    SET "PYTHON_BAT=%OSGEO_PATH%\python-qgis.bat"
) ELSE IF EXIST "%OSGEO_PATH%\python-qgis-ltr.bat" (
    SET "PYTHON_BAT=%OSGEO_PATH%\python-qgis-ltr.bat"
) ELSE (
    START CMD /C "ECHO File python-qgis(.bat) non trovato in %OSGEO_PATH%. && PAUSE"
    GOTO EXITHERE
)

REM === Percorso plugin utente ===
SET "QGIS3_PATH=%userprofile%\AppData\Roaming\QGIS\QGIS3\profiles\default\python"

IF NOT EXIST "%QGIS3_PATH%" (
    START CMD /C "ECHO La cartella utente QGIS3 non esiste. Avvia QGIS almeno una volta. && PAUSE"
    GOTO EXITHERE
)

SET "QGIS_PLUGIN_PATH=%QGIS3_PATH%\plugins"

IF NOT EXIST "%QGIS_PLUGIN_PATH%" (
    MKDIR "%QGIS_PLUGIN_PATH%"
    ECHO Cartella plugin creata: %QGIS_PLUGIN_PATH%
)

REM === Assicura pip ===
CALL "%PYTHON_BAT%" -m pip --version >NUL 2>&1
IF ERRORLEVEL 1 (
    CALL "%PYTHON_BAT%" -m ensurepip
)

CALL "%PYTHON_BAT%" -m pip install --upgrade pip

REM === Installa librerie richieste ===
CALL "%PYTHON_BAT%" -m pip install asyncio bleak pandas dbfread

IF ERRORLEVEL 1 (
    START CMD /C "ECHO Errore durante l'installazione dei pacchetti Python. Contattare eflows@isprambiente.it && PAUSE"
    GOTO EXITHERE
)

REM === Test asyncio ===
CALL "%PYTHON_BAT%" -c "import asyncio" >NUL 2>&1
IF ERRORLEVEL 1 (
    START CMD /C "ECHO ERRORE: asyncio non è disponibile nel Python di QGIS. && PAUSE"
    GOTO EXITHERE
)

REM === Rimuove vecchio plugin se presente ===
IF EXIST "%QGIS_PLUGIN_PATH%\mapstream" (
    RD /S /Q "%QGIS_PLUGIN_PATH%\mapstream"
)

REM === Copia nuovo plugin ===
XCOPY /E /Y "%~dp0\mapstream" "%QGIS_PLUGIN_PATH%\mapstream\"

START CMD /C "ECHO Plugin MapStream installato correttamente. && PAUSE"

:EXITHERE
ENDLOCAL
